/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20.binding.soap;

import org.w3.ns.wsdl.soap.Module;

import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAPModuleImpl extends AbstractWSDLElementImpl<Module> implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.soap.SOAPModule {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public SOAPModuleImpl(final Module m) {
        this.model = m;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

    }

    public String getRef() {
        return this.model.getRef();
    }

    public boolean isRequired() {
        return this.model.isRequired();
    }
}
