
package com.ebmwebsourcing.commons.wsdl.util;

import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractDescriptionImpl;

public class Util {

    @SuppressWarnings("unchecked")
    public static Map<FeatureConstants, Object> convertWSDLFeatures2SchemaFeature(final Description desc) {
        final Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();
        features
                .put(
                        FeatureConstants.VERBOSE,
                        ((AbstractDescriptionImpl) desc)
                                .getFeatureValue(com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants.VERBOSE));
        features
                .put(
                        FeatureConstants.IMPORT_DOCUMENTS,
                        ((AbstractDescriptionImpl) desc)
                                .getFeatureValue(com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants.IMPORT_DOCUMENTS));
        return features;
    }

    public static String getPrefix(final String name) {
        String res = null;
        if (name.indexOf(":") != -1) {
            res = name.substring(0, name.indexOf(":"));
        }
        return res;
    }

    public static String getLocalPartWithoutPrefix(final String name) {
        String res = name;
        if (name.indexOf(":") != -1) {
            res = name.substring(name.indexOf(":") + 1, name.length());
        }
        return res;
    }
}
