/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.util;

import org.jdom.JDOMException;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.commons.schema.util.JDomAnalyzer;
import com.ebmwebsourcing.commons.wsdl.util.Constants.WSDLVersionConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDLJDomAnalyzer extends JDomAnalyzer {

    private WSDLVersionConstants version;

    public WSDLJDomAnalyzer(final InputSource input) throws JDOMException {
        super(input);

        if ((this.getDocument().getRootElement().getName()
                .equals(com.ebmwebsourcing.commons.wsdl.impl.wsdl20.Constants.WSDL20_ROOT_TAG))
                && (this.getDocument().getRootElement().getNamespaceURI()
                        .equals(com.ebmwebsourcing.commons.wsdl.impl.wsdl20.Constants.WSDL_20_NAMESPACE))) {
            this.version = WSDLVersionConstants.WSDL20;
        }
        if ((this.getDocument().getRootElement().getName()
                .equals(com.ebmwebsourcing.commons.wsdl.impl.wsdl11.Constants.WSDL11_ROOT_TAG))
                && (this.getDocument().getRootElement().getNamespaceURI()
                        .equals(com.ebmwebsourcing.commons.wsdl.impl.wsdl11.Constants.WSDL_11_NAMESPACE))) {
            this.version = WSDLVersionConstants.WSDL11;
        }

    }

    public WSDLVersionConstants getVersion() {
        return this.version;
    }

}
