/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl11.WSDLJAXBContext;
import com.ebmwebsourcing.commons.wsdl.util.WSDLJDomAnalyzer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xmlsoap.schemas.wsdl.TDefinitions;

public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    private static Unmarshaller unmarshaller = null;
    private static WSDLException unmarshallerCreationEx = null;

    private static TDefinitions convertStream2WSDL11Definition(Source wsdlDescriptorStream) throws WSDLException {
        try {
            JAXBElement wsdlBinding = WSDLReaderImpl.getUnMarshaller().unmarshal(wsdlDescriptorStream, TDefinitions.class);
            return (TDefinitions)wsdlBinding.getValue();
        }
        catch (JAXBException e) {
            throw new WSDLException("Failed to build Java bindings from WSDL descriptor XML document", e);
        }
    }

    public static Unmarshaller getUnMarshaller() throws WSDLException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static JAXBContext getJaxbContext() {
        return WSDLJAXBContext.getJaxbContext();
    }

    public Description readWSDL(URI wsdlURI) throws WSDLException {
        Description desc = null;
        try {
            InputStream input = null;
            File f = new File(wsdlURI);
            input = f.exists() ? new FileInputStream(f) : wsdlURI.toURL().openStream();
            desc = this.readWSDL(wsdlURI, SourceHelper.convertInputSource2DOMSource((InputSource)new InputSource(input)));
        }
        catch (MalformedURLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        catch (IOException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        catch (WSDLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        catch (XmlException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        return desc;
    }

    public Description readWSDL(Document wsdlDocument) throws WSDLException {
        Description desc = null;
        try {
            desc = this.readWSDL(new URI(wsdlDocument.getDocumentURI()), new DOMSource(wsdlDocument));
        }
        catch (URISyntaxException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

    public Description readWSDL(URI baseURI, DOMSource inputSource) throws WSDLException {
        DescriptionImpl desc = null;
        try {
            if (this.analyzer == null) {
                DOMSource sourcebis = SourceHelper.cloneSource((DOMSource)inputSource);
                this.analyzer = new WSDLJDomAnalyzer(SourceHelper.convertDOMSource2InputSource((DOMSource)sourcebis));
            }
            DOMSource source = SourceHelper.cloneSource((DOMSource)inputSource);
            TDefinitions def = WSDLReaderImpl.convertStream2WSDL11Definition(source);
            desc = new DescriptionImpl(baseURI, def, this.analyzer.getDocument(), this.getFeatures());
        }
        catch (JDOMException e) {
            throw new WSDLException(e);
        }
        catch (XmlException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

    static {
        try {
            WSDLJAXBContext.createContext();
            unmarshaller = WSDLJAXBContext.getJaxbContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            WSDLException jaxbContextCreationEx = new WSDLException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new WSDLException("Failed to create the JAXB unmarshaller", jaxbContextCreationEx);
        }
        catch (WSDLException e) {
            WSDLException jaxbContextCreationEx = new WSDLException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new WSDLException("Failed to create the JAXB unmarshaller", jaxbContextCreationEx);
        }
    }
}

