/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.wsdl.util;

import java.net.URI;
import java.net.URISyntaxException;

public class Constants {
    public static final String WSDL11_PACKAGE = "com.ebmwebsourcing.commons.wsdl.impl.wsdl11";
    public static final String WSDL20_PACKAGE = "com.ebmwebsourcing.commons.wsdl.impl.wsdl20";

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MEPPatternConstants {
        IN_ONLY("http://www.w3.org/ns/wsdl/in-only"),
        ROBUST_IN_ONLY("http://www.w3.org/ns/wsdl/robust-in-only"),
        IN_OUT("http://www.w3.org/ns/wsdl/in-out"),
        IN_OPTIONAL_OUT("http://www.w3.org/ns/wsdl/in-optional-out"),
        OUT_ONLY("http://www.w3.org/ns/wsdl/out-only"),
        ROBUST_OUT_ONLY("http://www.w3.org/ns/wsdl/robust-out-only"),
        OUT_IN("http://www.w3.org/ns/wsdl/out-in"),
        OUT_OPTIONAL_IN("http://www.w3.org/ns/wsdl/out-optional-in");

        private final String nameSpace;
        private final URI patternURI;

        public static MEPPatternConstants valueOf(URI pattern) {
            MEPPatternConstants result = null;
            if (pattern != null) {
                for (MEPPatternConstants p : MEPPatternConstants.values()) {
                    if (!p.nameSpace.equals(pattern.toString())) continue;
                    result = p;
                }
            }
            return result;
        }

        private MEPPatternConstants(String nameSpace) {
            this.nameSpace = nameSpace;
            try {
                this.patternURI = new URI(nameSpace);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        }

        public URI value() {
            return this.patternURI;
        }

        public boolean equals(URI pattern) {
            return this.toString().equals(pattern.toString());
        }

        public String toString() {
            return this.nameSpace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SOAPMEPConstants {
        ONE_WAY("http://www.w3.org/2006/08/soap/mep/one-way/"),
        REQUEST_RESPONSE("http://www.w3.org/2003/05/soap/mep/request-response"),
        SOAP_RESPONSE("http://www.w3.org/2003/05/soap/mep/soap-response/");

        private final String nameSpace;
        private final URI mepURI;

        public static SOAPMEPConstants valueOf(URI pattern) {
            SOAPMEPConstants result = null;
            if (pattern != null) {
                for (SOAPMEPConstants mep : SOAPMEPConstants.values()) {
                    if (!mep.nameSpace.equals(pattern.toString())) continue;
                    result = mep;
                }
            }
            return result;
        }

        private SOAPMEPConstants(String nameSpace) {
            this.nameSpace = nameSpace;
            try {
                this.mepURI = new URI(nameSpace);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        }

        public URI value() {
            return this.mepURI;
        }

        public boolean equals(URI mep) {
            return this.toString().equals(mep.toString());
        }

        public String toString() {
            return this.nameSpace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WSDLVersionConstants {
        WSDL11("http://schemas.xmlsoap.org/wsdl/"),
        WSDL20("http://www.w3.org/ns/wsdl");

        private final String nameSpace;
        private final URI version;

        public static WSDLVersionConstants valueOf(URI pattern) {
            WSDLVersionConstants result = null;
            if (pattern != null) {
                for (WSDLVersionConstants version : WSDLVersionConstants.values()) {
                    if (!version.nameSpace.equals(pattern.toString())) continue;
                    result = version;
                }
            }
            return result;
        }

        private WSDLVersionConstants(String nameSpace) {
            this.nameSpace = nameSpace;
            try {
                this.version = new URI(nameSpace);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        }

        public URI value() {
            return this.version;
        }

        public boolean equals(URI version) {
            return this.toString().equals(version.toString());
        }

        public String toString() {
            return this.nameSpace;
        }
    }
}

