package com.ebmwebsourcing.easybox.api;

public final class XQueryValidationRuleReport {

    private final XQueryValidationRule rule;
    private final boolean isOk;
    // TODO : add affected nodes.
    
    public XQueryValidationRuleReport(XQueryValidationRule rule, boolean isOk) {
        assert rule != null;
        this.rule = rule;
        this.isOk = isOk;
    }

    public XQueryValidationRule getRule() {
        return rule;
    }

    public boolean getIsOk() {
        return isOk;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (isOk ? 1231 : 1237);
        result = prime * result + ((rule == null) ? 0 : rule.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XQueryValidationRuleReport other = (XQueryValidationRuleReport) obj;
        if (isOk != other.isOk)
            return false;
        if (rule == null) {
            if (other.rule != null)
                return false;
        } else if (!rule.equals(other.rule))
            return false;
        return true;
    }
    
    @Override
    public String toString() {
        return String.format("[%s] %s => %s", rule.getName(), rule.getDescription(), isOk ? "OK" : "KO");
    }
    
}
