package com.ebmwebsourcing.easybox.api;


public interface XmlObjectFactory {

    /**
     * Wrap any object into an implementation of {@link XmlObjectNode}.
     * Implementation class is guessed from known meta-information.
     * 
     * @param obj
     *            Internal model object to be wrapped.
     * @return Newly created concrete {@link XmlObjectNode}.
     */
    XmlObjectNode wrap(Object obj);

    /**
     * Wrap any object into a specific implementation of {@link XmlObjectNode}.
     * 
     * @param <X>
     *            Type of desired {@link XmlObjectNode} interface.
     * @param obj
     *            Model object to be wrapped.
     * @param xmlObjectClassOrInterface
     *            Desired {@link XmlObjectNode} interface class. For convenience,
     *            one can also provide directly the desired implementation class
     *            to prevent unnecessary lookup in metadata.
     * @return Newly created concrete {@link XmlObjectNode}.
     */
    <X extends XmlObjectNode> X wrap(Object obj, Class<X> xmlObjectClassOrInterface);

    /**
     * Create a new {@link XmlObjectNode} given its interface class. Implementation
     * class is guessed from known meta-information.
     * 
     * @param <X>
     *            Class of {@link XmlObjectNode} to be created.
     * @param xmlObjectClassOrInterface
     *            Class of {@link XmlObjectNode} to be created.
     * @return Newly created {@link XmlObjectNode}.
     */
    <X extends XmlObjectNode> X create(Class<X> xmlObjectClassOrInterface);

}
