/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.WSDLVersionConstants;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;
import org.petalslink.abslayer.service.api.Service;

public class Descriptions {
    private static final long serialVersionUID = 1L;
    private static XmlContext xmlContext;
    String processNamespace;
    List<Import> imports = new ArrayList<Import>();
    List<Description> descriptions = new ArrayList<Description>();
    List<Schema> schemas = new ArrayList<Schema>();

    public Descriptions(String string, String string2, List<Import> list) {
        this.processNamespace = string;
        this.imports = list;
        for (Import import_ : this.imports) {
            if (import_.getDescription() != null) {
                this.descriptions.add(import_.getDescription());
                continue;
            }
            if (import_.getSchema2() == null) continue;
            this.schemas.add(import_.getSchema2());
        }
    }

    public void addImport(Import import_) {
        this.imports.add(import_);
        if (import_.getDescription() != null) {
            this.descriptions.add(import_.getDescription());
        } else if (import_.getSchema2() != null) {
            this.schemas.add(import_.getSchema2());
        }
    }

    public void removeImport(Import import_) {
        this.imports.remove(import_);
        if (import_.getDescription() != null) {
            this.descriptions.remove(import_.getDescription());
        } else if (import_.getSchema2() != null) {
            this.schemas.remove(import_.getSchema2());
        }
    }

    public final String getProcessNamespace() {
        return this.processNamespace;
    }

    public static Description readDescription11(URL uRL) throws XmlObjectReadException {
        XmlObjectReader xmlObjectReader = xmlContext.createReader();
        return (Description)Factory.getInstance().wrap(xmlObjectReader.readDocument(uRL, Definitions.class));
    }

    public static Description readDescription20(URL uRL) {
        throw new UnsupportedOperationException();
    }

    public static Schema readSchema(URL uRL) throws SchemaException {
        XmlObjectReader xmlObjectReader = xmlContext.createReader();
        try {
            return (Schema)xmlObjectReader.readDocument(uRL, Schema.class);
        }
        catch (XmlObjectReadException xmlObjectReadException) {
            throw new UncheckedException((Throwable)xmlObjectReadException);
        }
    }

    public List<Import> getBPELImports() {
        return this.imports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSchema(Schema schema) {
        List<Schema> list = this.schemas;
        synchronized (list) {
            this.schemas.add(schema);
        }
    }

    public PartnerLinkType getPartnerLinkType(QName qName) {
        for (Description description : this.descriptions) {
            PartnerLinkType partnerLinkType = description.getPartnerLinkType(qName);
            if (partnerLinkType == null) continue;
            return partnerLinkType;
        }
        return null;
    }

    public Description getDescriptionByService(QName qName) {
        for (Description description : this.descriptions) {
            if (description.findInterface(qName) == null) continue;
            return description;
        }
        return null;
    }

    public Description getDescriptionByInterface(QName qName) {
        for (Description description : this.descriptions) {
            if (description.findInterface(qName) == null) continue;
            return description;
        }
        return null;
    }

    public Description getDescriptionByProperty(QName qName) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> findElementsInAllSchema(QName qName) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Description object : this.descriptions) {
            arrayList.addAll(object.findElementsInAllSchema(qName));
        }
        List<Schema> list = this.schemas;
        synchronized (list) {
            for (Schema schema : this.schemas) {
                Element element = SchemaHelper.findElementByQName((XmlObject)schema, (QName)qName);
                if (element == null) continue;
                arrayList.add(element);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> findTypesInAllSchema(QName qName) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Description object : this.descriptions) {
            Type type = SchemaHelper.findTypeByQName((XmlObject)object.getModel(), (QName)qName);
            if (type == null) continue;
            arrayList.add(type);
        }
        List<Schema> list = this.schemas;
        synchronized (list) {
            for (Schema schema : this.schemas) {
                Type type = SchemaHelper.findTypeByQName((XmlObject)schema, (QName)qName);
                if (type == null) continue;
                arrayList.add(type);
            }
        }
        return arrayList;
    }

    public Endpoint findEndpoint(String string) {
        for (Description description : this.descriptions) {
            Endpoint endpoint = description.findEndpoint(string);
            if (endpoint == null) continue;
            return endpoint;
        }
        return null;
    }

    public Interface findInterface(QName qName) {
        Interface interface_ = null;
        for (Description description : this.descriptions) {
            interface_ = description.findInterface(qName);
            if (interface_ == null) continue;
            return interface_;
        }
        return null;
    }

    public Collection<Endpoint> findEndpointsImplementingInterface(Interface interface_) {
        assert (interface_ != null);
        HashSet<Endpoint> hashSet = new HashSet<Endpoint>();
        for (Description description : this.descriptions) {
            assert (description != null);
            hashSet.addAll(description.findEndpointsImplementingInterface(interface_));
        }
        return hashSet;
    }

    public Property getProperty(QName qName) {
        for (Description description : this.descriptions) {
            Property property = description.findProperty(qName);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public List<PropertyAlias> getPropertyAliases4ThisProperty(QName qName) {
        ArrayList<PropertyAlias> arrayList = new ArrayList<PropertyAlias>();
        for (Description description : this.descriptions) {
            arrayList.addAll(description.getPropertyAliases4ThisProperty(qName));
        }
        return arrayList;
    }

    public Service findService(QName qName) {
        for (Description description : this.descriptions) {
            Service service = description.findService(qName);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public NamespaceMapperImpl getNamespaces() {
        throw new UnsupportedOperationException();
    }

    public Message findMessage(QName qName) {
        Message message = null;
        for (Description description : this.descriptions) {
            message = description.findMessage(qName);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public WSDLVersionConstants getVersion() {
        throw new UnsupportedOperationException();
    }

    public List<Binding> getBindings() {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        for (Description description : this.descriptions) {
            arrayList.addAll(description.getBindings());
        }
        return arrayList;
    }

    public List<Service> getServices() {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        for (Description description : this.descriptions) {
            arrayList.addAll(description.getServices());
        }
        return arrayList;
    }

    static {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        xmlContext = xmlContextFactory.newContext();
    }
}

