/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TRole;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PartnerLinkValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELWarningImpl;
import com.ibm.wsdl.AbstractWSDLElement;

public class PartnerLinkValidatorImpl implements PartnerLinkValidator {

	private PartnerLink partnerLink = null;
	
	public PartnerLinkValidatorImpl(final PartnerLink partnerLink) {
		this.partnerLink = partnerLink;
	}
	
	public void validate() {
		// validation
		try {
			if(((this.partnerLink.getMyRole() == null) || (this.partnerLink.getMyRole().trim().length() == 0))&&
					((this.partnerLink.getPartnerRole() == null) || (this.partnerLink.getPartnerRole().trim().length() == 0))) {
				BPELStaticAnalysisImpl.getInstance().addWarning(new BPELWarningImpl(this.partnerLink, "In PartnerLink " + this.partnerLink.getName() + " => No defined role: neither myRole or partnerRole"));
			}
			final BPELProcess process = ScopeUtil.getProcess((BPELElement) ((BPELElementImpl) this.partnerLink).getParent());

			if((this.partnerLink.getPartnerLinkType() == null) || (this.partnerLink.getPartnerLinkType().toString().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => PartnerLinkType cannot be null or empty")));
			} else {
				final PartnerLinkType plt = process.getImports().getPartnerLinkType(this.partnerLink.getPartnerLinkType());
				if(plt == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => Impossible to find in wsdl descriptions the partnerLinkType: " + this.partnerLink.getPartnerLinkType())));
				} else {
					for(final Role r: plt.getRoles()) {
						final InterfaceType itf = r.getInterface();
						if(itf == null) {
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("PartnerLinkType Definition Error => Impossible to find in wsdl descriptions the interface : " + ((TRole)((AbstractWSDLElementImpl)r).getModel()).getPortType() + " corresponding to role " + r.getName())));
						}
					}
				}
			}
			if(this.partnerLink.getInitializePartnerRole() != null) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.partnerLink, "[BPEL engine Restriction] In PartnerLink " + this.partnerLink.getName() + " => The value of InitializePartnerRole is ignored : default and unique value for moment = true"));
			}
		} catch (final WSDL4BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.partnerLink, new BPELException("In PartnerLink " + this.partnerLink.getName() + " => " + e.getMessage())));
		}
	}

}
