/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.inout;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.XMLConstants;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ValidatorManagerImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELJAXBContext {

    /**
     * The JAXB context
     */
    private JAXBContext jaxbContext;
    
    private Schema schema;

	private final List<Class<?>> defaultObjectFactories = new ArrayList<Class<?>>(Arrays.asList(new Class<?>[] {
            com.ebmwebsourcing.easybpel.model.bpel.executable.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel.serviceref.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel._abstract.ObjectFactory.class,
            com.ebmwebsourcing.easybpel.model.bpel.varprop.ObjectFactory.class,
            org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.ObjectFactory.class,
            }));

	private static BPELJAXBContext instance = null;
	
	static {
		// set validator
		ValidatorManagerImpl.getInstance();
	}
	
    /**
     * Private object initializations
     */
    private BPELJAXBContext() throws BPELException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        
        final URL schemaUrlBpelExecutable = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_executable.xsd");
        final URL schemaUrlBpelServiceRef = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_serviceref.xsd");
        final URL schemaUrlBpel_abstract = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_abstract_common_base.xsd");
        final URL schemaUrlBpel_varprop = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_varprop.xsd");
        final URL schemaUrlBpelParnterLink = BPELJAXBContext.class.getResource("/" + "schema/bpel/2_0/ws-bpel_plnktype.xsd");

        try {
            this.schema = factory.newSchema(new StreamSource[] { 
            		new StreamSource(schemaUrlBpelExecutable.openStream()), 
            		new StreamSource(schemaUrlBpelServiceRef.openStream()), 
            		new StreamSource(schemaUrlBpel_abstract.openStream()), 
            		new StreamSource(schemaUrlBpel_varprop.openStream()),
            		new StreamSource(schemaUrlBpelParnterLink.openStream())
            		});

           
            
            this.jaxbContext = JAXBContext.newInstance(this.defaultObjectFactories.toArray(new Class[this.defaultObjectFactories.size()]));
        } catch (final SAXException e) {
            throw new BPELException(e);
        } catch (final IOException e) {
            throw new BPELException(e);
        } catch (final JAXBException e) {
            throw new BPELException(e);
        }
    }
    
	public static BPELJAXBContext getInstance() throws BPELException {
		if(instance == null) {
			instance = new BPELJAXBContext();
		}
		return instance;
	}


    /**
     * @return the jaxbContext
     */
    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }
    

    public Schema getSchema() {
		return this.schema;
	}
}
