/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Document;
import org.jdom.Element;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.TechnicalException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

public class BPELFaultHandler implements FaultHandler {

	private Logger log = Logger.getLogger(BPELFaultHandler.class.getName());

	private final Descriptions desc;

	private final BPELProcess bpeldefinition;

	private final Invoke invoke;
	
	private final SOAPAdapter soapAdapter;

	public BPELFaultHandler(final BPELProcess bpeldefinition, final Invoke invoke) {
		this.desc = bpeldefinition.getImports();
		this.bpeldefinition = bpeldefinition;
		this.invoke = invoke;
		this.soapAdapter = new SOAPAdapter(this.bpeldefinition);
	}

	public boolean match(final Scope scope, final Fault f, final Exception e, final Scope faultScope) throws CoreException {
		boolean res = false;
		try {
			if((f.getFaultName() != null) && f.getFaultName().getLocalPart().equals("unknown") && (f.getVariable() == null)) {
				this.log.finest("faultName = " + f.getFaultName());
				res = true;
			} else if(e instanceof CoreException) {
				if(e instanceof UserDefinedException) {
					org.ow2.easywsdl.wsdl.api.Fault faultDef = ((UserDefinedException)e).getFaultDefinition();
					final BPELVariable var = (BPELVariable) f.getVariable();
					if(faultDef == null) {
						faultDef = this.findFaultDefinition(this.bpeldefinition, this.invoke, f.getFaultName(), var);
					}
					if( !res && (var != null) && (var.getElement() != null) && var.getElement().equals(faultDef.getElement())) {
						final Variable v = faultScope.findVariable(var.getQName());
						final BPELInternalMessage faultMessage = new BPELInternalMessageImpl();

						if(((UserDefinedException)e).getFault() == null) {
							final Variable vf = faultScope.findVariable(new QName(((UserDefinedException)e).getFaultVariableName()));
							final BPELInternalMessage formattedSoapFault = (BPELInternalMessage) (this.soapAdapter).formatFault(vf.getValue());
							final Element soapFault = this.soapAdapter.createSOAPFault(formattedSoapFault.getContent());
							final BPELInternalMessage faultSoap = new BPELInternalMessageImpl();
							faultSoap.setContent(soapFault);
							((UserDefinedException)e).setFault(faultSoap);
						}
						final Element detail = this.soapAdapter.getDetails((Element) ((UserDefinedException)e).getFault().getContent());
						final Document doc = new Document((Element) (Util.getChildElements(detail).get(0)).clone());
						faultMessage.setContent(doc.getRootElement());
						faultMessage.setEndpoint(((UserDefinedException)e).getFault().getEndpoint());
						faultMessage.setOperationName(((UserDefinedException)e).getFault().getOperationName());
						faultMessage.setQName(((UserDefinedException)e).getFault().getQName());
						faultMessage.setService(((UserDefinedException)e).getFault().getService());
						v.setValue(faultMessage);

						res = true;
					}
					if( !res && (var != null) && (var.getMessageType() != null) && var.getMessageType().equals(faultDef.getMessageName())) {
						final Variable v = faultScope.findVariable(var.getQName());
						final BPELInternalMessage faultMessage = new BPELInternalMessageImpl();
						if(((UserDefinedException)e).getFault() == null) {
							final Variable vf = faultScope.findVariable(new QName(((UserDefinedException)e).getFaultVariableName()));
							final BPELInternalMessage formattedSoapFault = (BPELInternalMessage) (this.soapAdapter).formatFault(vf.getValue());
							final Element soapFault = this.soapAdapter.createSOAPFault(formattedSoapFault.getContent());
							final BPELInternalMessage faultSoap = new BPELInternalMessageImpl();
							faultSoap.setContent(soapFault);
							((UserDefinedException)e).setFault(faultSoap);
						}
						final Element detail = this.soapAdapter.getDetails((Element) ((UserDefinedException)e).getFault().getContent());
						final Document doc = new Document((Element) (Util.getChildElements(detail).get(0)).clone());
						faultMessage.setContent(doc.getRootElement());
						faultMessage.setEndpoint(((UserDefinedException)e).getFault().getEndpoint());
						faultMessage.setOperationName(((UserDefinedException)e).getFault().getOperationName());
						faultMessage.setQName(((UserDefinedException)e).getFault().getQName());
						faultMessage.setService(((UserDefinedException)e).getFault().getService());
						v.setValue(faultMessage);

						res = true;
					}
				}
				if( !res && (f.getFaultName() != null) && f.getFaultName().toString().equals(((CoreException)e).getName())) {
					res = true;
				} 
				if( !res && (f.getVariable().getQName() != null) && f.getVariable().getQName().toString().equals(((CoreException)e).getName())) {
					res = true;
				}
			}
		} catch(final BPELException ex) {
			throw new CoreException(e);
		}
		return res;
	}

	private org.ow2.easywsdl.wsdl.api.Fault findFaultDefinition(
			final BPELProcess bpeldef, final Invoke inv, final QName faultName,
			final BPELVariable var) throws BPELException {
		org.ow2.easywsdl.wsdl.api.Fault res = null;
		if(inv != null) {
			final InterfaceType itf = bpeldef.getImports().getInterface(inv.getInterface());
			if(itf == null) {
				throw new BPELException("Impossible to find interface corresponding to: " + inv.getInterface());
			}
			final Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.invoke.getOperation()));
			res = op.getFault(faultName.getLocalPart());
		} else {
			boolean found = false;
			for(final InterfaceType itf: bpeldef.getImports().getInterfaces()) {
				for(final Operation op: itf.getOperations()) {
					if(op.getQName().getNamespaceURI().equals(faultName.getNamespaceURI())) {
						res = op.getFault(faultName.getLocalPart());
						if(res != null) {
							found = true;
							break;
						}
					}
				}
				if(found) {
					break;
				}
			}

		}
		return res;
	}

	public BPELException getModelExceptionFromGenericException  (
			final Scope scope, final Exception e) throws CoreException {

		BPELException res = null;
		if(e instanceof CoreException) {

			if(this.invoke == null) {
				throw new CoreException("Invoke cannot be null");
			}
			if(this.bpeldefinition == null) {
				throw new CoreException("BPEL definition cannot be null");
			}

			final Message fault = ((CoreException)e).getFault();
			if(!(fault instanceof BPELInternalMessage)) {
				throw new CoreException("Impossible to understand the fault: " + fault + " => " + e.getMessage(), e);
			}
			final Element details = this.soapAdapter.getDetails(((BPELInternalMessage)fault).getContent());
			if((details != null) && (details.getChildren().size() > 1)) {
				throw new CoreException("Sorry, but the management of severals faults is not supported");
			}
			if((details != null) && (Util.getChildElements(details).size() == 1)) {
				final Element elmt = Util.getChildElements(details).get(0);
				final QName faultElement = new QName(elmt.getNamespaceURI(), elmt.getName());
				final QName interfaceName = this.invoke.getInterface();
				if(interfaceName == null) {
					// TODO: find interface thanks to the operation
					throw new NotImplementedException();
				}
				final InterfaceType itf = this.desc.getInterface(interfaceName);
				if(itf == null) {
					throw new CoreException("Impossible to find interface with this name: " + interfaceName);
				}
				final Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.invoke.getOperation()));
				if(op == null) {
					throw new CoreException("Impossible to find operation with this name: " + this.invoke.getOperation());
				}
				final List<org.ow2.easywsdl.wsdl.api.Fault> faults = op.getFaults();
				for(final org.ow2.easywsdl.wsdl.api.Fault faultDef: faults) {
					final QName faultName = new QName(op.getQName().getNamespaceURI(), faultDef.getName());
					if((faultDef.getElement() != null)&&(faultDef.getElement().getQName().equals(faultElement))) {
						res = new UserDefinedException(faultName, null, faultDef, scope);
						res.setName(faultName.toString());
						res.setFault(((BPELInternalMessage)fault));
						break;
					} else if((faultDef.getMessageName() != null)&&(faultName.equals(faultElement))) {
						res = new UserDefinedException(faultName, null, faultDef, scope);
						res.setName(faultName.toString());
						res.setFault(((BPELInternalMessage)fault));
						break;
					} 
				}
			} else {
				res = new TechnicalException(e);
			}

		} else {
			res = new BPELException(e);
		}
		return res;
	}



	public void setLog(final Logger logger) {
		this.log = logger;
	}

}
