/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.verification;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.verification.TypeVerifier;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVerifierImpl
implements TypeVerifier {
    private static Logger log = Logger.getLogger(TypeVerifierImpl.class.getName());
    private final BPELProcess bpelDefinition;

    public TypeVerifierImpl(BPELProcess bPELProcess) {
        this.bpelDefinition = bPELProcess;
    }

    public Class<?> compare(Element element, Element element2) throws BPELException {
        Class clazz = null;
        if (this.isInteger(element) && this.isInteger(element2)) {
            clazz = Integer.class;
        } else if (this.isBoolean(element) && this.isBoolean(element2)) {
            clazz = Boolean.class;
        } else if (this.isDateTime(element) && this.isDateTime(element2)) {
            clazz = Date.class;
        } else if (this.isString(element) && this.isString(element2)) {
            clazz = String.class;
        }
        return clazz;
    }

    public boolean isInteger(Element element) throws BPELException {
        boolean bl = false;
        String string = element.getAttributeValue("type");
        if (string == null) {
            string = element.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName qName = null;
        if (string != null) {
            Namespace namespace;
            String string2 = Util.getPrefix((String)string);
            qName = new QName(string);
            if (string2 != null && (namespace = element.getNamespace(string2)) != null) {
                qName = new QName(namespace.getURI(), Util.getLocalPartWithoutPrefix((String)string));
            }
        } else {
            List list = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(element.getNamespaceURI(), element.getName()));
            if (list.size() == 0) {
                if (element.getNamespaceURI() == null || element.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + element + " not found in all schemas");
                }
            }
            int n = -1;
            if (list.size() > 1) {
                Iterator iterator = list.iterator();
                org.ow2.easywsdl.schema.api.Element element2 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                org.ow2.easywsdl.schema.api.Element element3 = null;
                int n2 = 0;
                while (iterator.hasNext() && n == -1) {
                    element3 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                    if (((Type)element2.getType()).getQName() != null && ((Type)element2.getType()).getQName().equals(((Type)element3.getType()).getQName())) {
                        n = n2;
                    }
                    element2 = element3;
                    ++n2;
                }
            }
            qName = n >= 0 ? ((Type)((org.ow2.easywsdl.schema.api.Element)list.get(n)).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (qName.equals(SchemaFactory.getDefaultSchema().getTypeInt().getQName()) || qName.equals(SchemaFactory.getDefaultSchema().getTypeInteger().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(element) + " is an integer");
            bl = true;
        }
        return bl;
    }

    public boolean isDateTime(Element element) throws BPELException {
        boolean bl = false;
        String string = element.getAttributeValue("type");
        if (string == null) {
            string = element.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName qName = null;
        if (string != null) {
            Namespace namespace;
            String string2 = Util.getPrefix((String)string);
            qName = new QName(string);
            if (string2 != null && (namespace = element.getNamespace(string2)) != null) {
                qName = new QName(namespace.getURI(), Util.getLocalPartWithoutPrefix((String)string));
            }
        } else {
            List list = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(element.getNamespaceURI(), element.getName()));
            if (list.size() == 0) {
                if (element.getNamespaceURI() == null || element.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + element + " not found in all schemas");
                }
            }
            int n = -1;
            if (list.size() > 1) {
                Iterator iterator = list.iterator();
                org.ow2.easywsdl.schema.api.Element element2 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                org.ow2.easywsdl.schema.api.Element element3 = null;
                int n2 = 0;
                while (iterator.hasNext() && n == -1) {
                    element3 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                    if (((Type)element2.getType()).getQName() != null && ((Type)element2.getType()).getQName().equals(((Type)element3.getType()).getQName())) {
                        n = n2;
                    }
                    element2 = element3;
                    ++n2;
                }
            }
            qName = n >= 0 ? ((Type)((org.ow2.easywsdl.schema.api.Element)list.get(n)).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (qName.equals(SchemaFactory.getDefaultSchema().getTypeDateTime().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(element) + " is an datetime");
            bl = true;
        }
        return bl;
    }

    public boolean isString(Element element) throws BPELException {
        boolean bl = false;
        String string = element.getAttributeValue("type");
        if (string == null) {
            string = element.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName qName = null;
        if (string != null) {
            Namespace namespace;
            String string2 = Util.getPrefix((String)string);
            qName = new QName(string);
            if (string2 != null && (namespace = element.getNamespace(string2)) != null) {
                qName = new QName(namespace.getURI(), Util.getLocalPartWithoutPrefix((String)string));
            }
        } else {
            List list = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(element.getNamespaceURI(), element.getName()));
            if (list.size() == 0) {
                if (element.getNamespaceURI() == null || element.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + element + " not found in all schemas");
                }
            }
            int n = -1;
            if (list.size() > 1) {
                Iterator iterator = list.iterator();
                org.ow2.easywsdl.schema.api.Element element2 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                org.ow2.easywsdl.schema.api.Element element3 = null;
                int n2 = 0;
                while (iterator.hasNext() && n == -1) {
                    element3 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                    if (((Type)element2.getType()).getQName() != null && ((Type)element2.getType()).getQName().equals(((Type)element3.getType()).getQName())) {
                        n = n2;
                    }
                    element2 = element3;
                }
                ++n2;
            }
            qName = n >= 0 ? ((Type)((org.ow2.easywsdl.schema.api.Element)list.get(n)).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (qName.equals(SchemaFactory.getDefaultSchema().getTypeString().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(element) + " is a string");
            bl = true;
        }
        return bl;
    }

    public boolean isBoolean(Element element) throws BPELException {
        boolean bl = false;
        String string = element.getAttributeValue("type");
        if (string == null) {
            string = element.getAttributeValue("type", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName qName = null;
        if (string != null) {
            Namespace namespace;
            String string2 = Util.getPrefix((String)string);
            qName = new QName(string);
            if (string2 != null && (namespace = element.getNamespace(string2)) != null) {
                qName = new QName(namespace.getURI(), Util.getLocalPartWithoutPrefix((String)string));
            }
        } else {
            List list = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(element.getNamespaceURI(), element.getName()));
            if (list.size() == 0) {
                if (element.getNamespaceURI() == null || element.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new BPELException("Element " + element + " not found in all schemas");
                }
            }
            int n = -1;
            if (list.size() > 1) {
                Iterator iterator = list.iterator();
                org.ow2.easywsdl.schema.api.Element element2 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                org.ow2.easywsdl.schema.api.Element element3 = null;
                int n2 = 0;
                while (iterator.hasNext() && n == -1) {
                    element3 = (org.ow2.easywsdl.schema.api.Element)iterator.next();
                    if (((Type)element2.getType()).getQName() != null && ((Type)element2.getType()).getQName().equals(((Type)element3.getType()).getQName())) {
                        n = n2;
                    }
                    element2 = element3;
                }
                ++n2;
            }
            qName = n >= 0 ? ((Type)((org.ow2.easywsdl.schema.api.Element)list.get(n)).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (qName != null && qName.equals(SchemaFactory.getDefaultSchema().getTypeString().getQName())) {
            if (element.getText() != null && (element.getText().trim().equals("true") || element.getText().trim().equals("false"))) {
                log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(element) + " is a boolean");
                bl = true;
            }
        } else if (qName != null && qName.equals(SchemaFactory.getDefaultSchema().getTypeBoolean().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(element) + " is a boolean");
            bl = true;
        }
        return bl;
    }

    public Integer getIntValue(Element element) {
        Integer n = null;
        if (element.getText() != null && element.getText().trim().length() > 0) {
            n = Integer.parseInt(element.getText());
        }
        return n;
    }

    public String getStringValue(Element element) {
        return element.getText();
    }

    public Boolean getBooleanValue(Element element) {
        Boolean bl = null;
        if (element.getText() != null && element.getText().trim().length() > 0) {
            bl = Boolean.parseBoolean(element.getText());
        }
        return bl;
    }

    public Date getDateTimeValue(Element element) throws BPELException {
        Date date = null;
        if (element.getText() != null && element.getText().trim().length() > 0) {
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(element.getText());
                date = xMLGregorianCalendar.toGregorianCalendar().getTime();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new BPELException("Impossible to convert this date: " + element.getText() + " in element: " + element.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BPELException("Impossible to convert this date: " + element.getText() + " in element: " + element.getName());
            }
        }
        return date;
    }

    public boolean isNullValue(Element element) {
        boolean bl = false;
        if (element != null && element.getText() == null) {
            bl = true;
        }
        return bl;
    }
}

