/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.TechnicalException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.jdom.Document;
import org.jdom.Element;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;

public class BPELFaultHandler
implements FaultHandler {
    private Logger log = Logger.getLogger(BPELFaultHandler.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private final Invoke invoke;
    private final SOAPAdapter soapAdapter;

    public BPELFaultHandler(BPELProcess bPELProcess, Invoke invoke) {
        this.desc = bPELProcess.getImports();
        this.bpeldefinition = bPELProcess;
        this.invoke = invoke;
        this.soapAdapter = new SOAPAdapter(this.bpeldefinition);
    }

    public boolean match(Scope scope, com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault fault, Exception exception, Scope scope2) throws CoreException {
        boolean bl = false;
        try {
            if (fault.getFaultName() != null && fault.getFaultName().getLocalPart().equals("unknown") && fault.getVariable() == null) {
                this.log.finest("faultName = " + fault.getFaultName());
                bl = true;
            } else if (exception instanceof CoreException) {
                if (exception instanceof UserDefinedException) {
                    BPELInternalMessageImpl bPELInternalMessageImpl;
                    Element element;
                    BPELInternalMessage bPELInternalMessage;
                    Variable variable;
                    BPELInternalMessageImpl bPELInternalMessageImpl2;
                    Variable variable2;
                    Fault fault2 = ((UserDefinedException)((Object)exception)).getFaultDefinition();
                    BPELVariable bPELVariable = (BPELVariable)fault.getVariable();
                    if (fault2 == null) {
                        fault2 = this.findFaultDefinition(this.bpeldefinition, this.invoke, fault.getFaultName(), bPELVariable);
                    }
                    if (!bl && bPELVariable != null && bPELVariable.getElement() != null && bPELVariable.getElement().equals(fault2.getElement())) {
                        variable2 = scope2.findVariable(bPELVariable.getQName());
                        bPELInternalMessageImpl2 = new BPELInternalMessageImpl();
                        if (((UserDefinedException)((Object)exception)).getFault() == null) {
                            variable = scope2.findVariable(new QName(((UserDefinedException)((Object)exception)).getFaultVariableName()));
                            bPELInternalMessage = (BPELInternalMessage)this.soapAdapter.formatFault(variable.getValue());
                            element = this.soapAdapter.createSOAPFault((Element)bPELInternalMessage.getContent());
                            bPELInternalMessageImpl = new BPELInternalMessageImpl();
                            bPELInternalMessageImpl.setContent(element);
                            ((UserDefinedException)((Object)exception)).setFault((Message)bPELInternalMessageImpl);
                        }
                        variable = this.soapAdapter.getDetails((Element)((UserDefinedException)((Object)exception)).getFault().getContent());
                        bPELInternalMessage = new Document((Element)Util.getChildElements((Element)variable).get(0).clone());
                        bPELInternalMessageImpl2.setContent(bPELInternalMessage.getRootElement());
                        bPELInternalMessageImpl2.setEndpoint(((UserDefinedException)((Object)exception)).getFault().getEndpoint());
                        bPELInternalMessageImpl2.setOperationName(((UserDefinedException)((Object)exception)).getFault().getOperationName());
                        bPELInternalMessageImpl2.setQName(((UserDefinedException)((Object)exception)).getFault().getQName());
                        bPELInternalMessageImpl2.setService(((UserDefinedException)((Object)exception)).getFault().getService());
                        variable2.setValue((InternalMessage)bPELInternalMessageImpl2);
                        bl = true;
                    }
                    if (!bl && bPELVariable != null && bPELVariable.getMessageType() != null && bPELVariable.getMessageType().equals(fault2.getMessageName())) {
                        variable2 = scope2.findVariable(bPELVariable.getQName());
                        bPELInternalMessageImpl2 = new BPELInternalMessageImpl();
                        if (((UserDefinedException)((Object)exception)).getFault() == null) {
                            variable = scope2.findVariable(new QName(((UserDefinedException)((Object)exception)).getFaultVariableName()));
                            bPELInternalMessage = (BPELInternalMessage)this.soapAdapter.formatFault(variable.getValue());
                            element = this.soapAdapter.createSOAPFault((Element)bPELInternalMessage.getContent());
                            bPELInternalMessageImpl = new BPELInternalMessageImpl();
                            bPELInternalMessageImpl.setContent(element);
                            ((UserDefinedException)((Object)exception)).setFault((Message)bPELInternalMessageImpl);
                        }
                        variable = this.soapAdapter.getDetails((Element)((UserDefinedException)((Object)exception)).getFault().getContent());
                        bPELInternalMessage = new Document((Element)Util.getChildElements((Element)variable).get(0).clone());
                        bPELInternalMessageImpl2.setContent(bPELInternalMessage.getRootElement());
                        bPELInternalMessageImpl2.setEndpoint(((UserDefinedException)((Object)exception)).getFault().getEndpoint());
                        bPELInternalMessageImpl2.setOperationName(((UserDefinedException)((Object)exception)).getFault().getOperationName());
                        bPELInternalMessageImpl2.setQName(((UserDefinedException)((Object)exception)).getFault().getQName());
                        bPELInternalMessageImpl2.setService(((UserDefinedException)((Object)exception)).getFault().getService());
                        variable2.setValue((InternalMessage)bPELInternalMessageImpl2);
                        bl = true;
                    }
                }
                if (!bl && fault.getFaultName() != null && fault.getFaultName().toString().equals(((CoreException)((Object)exception)).getName())) {
                    bl = true;
                }
                if (!bl && fault.getVariable().getQName() != null && fault.getVariable().getQName().toString().equals(((CoreException)((Object)exception)).getName())) {
                    bl = true;
                }
            }
        }
        catch (BPELException bPELException) {
            throw new CoreException((Throwable)exception);
        }
        return bl;
    }

    private Fault findFaultDefinition(BPELProcess bPELProcess, Invoke invoke, QName qName, BPELVariable bPELVariable) throws BPELException {
        Fault fault = null;
        if (invoke != null) {
            InterfaceType interfaceType = (InterfaceType)bPELProcess.getImports().getInterface(invoke.getInterface());
            if (interfaceType == null) {
                throw new BPELException("Impossible to find interface corresponding to: " + invoke.getInterface());
            }
            Operation operation = (Operation)interfaceType.getOperation(new QName(interfaceType.getQName().getNamespaceURI(), this.invoke.getOperation()));
            fault = (Fault)operation.getFault(qName.getLocalPart());
        } else {
            boolean bl = false;
            for (InterfaceType interfaceType : bPELProcess.getImports().getInterfaces()) {
                for (Operation operation : interfaceType.getOperations()) {
                    if (!operation.getQName().getNamespaceURI().equals(qName.getNamespaceURI()) || (fault = (Fault)operation.getFault(qName.getLocalPart())) == null) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        return fault;
    }

    public BPELException getModelExceptionFromGenericException(Scope scope, Exception exception) throws CoreException {
        BPELException bPELException = null;
        if (exception instanceof CoreException) {
            if (this.invoke == null) {
                throw new CoreException("Invoke cannot be null");
            }
            if (this.bpeldefinition == null) {
                throw new CoreException("BPEL definition cannot be null");
            }
            Message message = ((CoreException)((Object)exception)).getFault();
            if (!(message instanceof BPELInternalMessage)) {
                throw new CoreException("Impossible to understand the fault: " + message + " => " + exception.getMessage(), (Throwable)exception);
            }
            Element element = this.soapAdapter.getDetails((Element)((BPELInternalMessage)message).getContent());
            if (element != null && element.getChildren().size() > 1) {
                throw new CoreException("Sorry, but the management of severals faults is not supported");
            }
            if (element != null && Util.getChildElements(element).size() == 1) {
                Element element2 = Util.getChildElements(element).get(0);
                QName qName = new QName(element2.getNamespaceURI(), element2.getName());
                QName qName2 = this.invoke.getInterface();
                if (qName2 == null) {
                    throw new NotImplementedException();
                }
                InterfaceType interfaceType = (InterfaceType)this.desc.getInterface(qName2);
                if (interfaceType == null) {
                    throw new CoreException("Impossible to find interface with this name: " + qName2);
                }
                Operation operation = (Operation)interfaceType.getOperation(new QName(interfaceType.getQName().getNamespaceURI(), this.invoke.getOperation()));
                if (operation == null) {
                    throw new CoreException("Impossible to find operation with this name: " + this.invoke.getOperation());
                }
                List list = operation.getFaults();
                for (Fault fault : list) {
                    QName qName3 = new QName(operation.getQName().getNamespaceURI(), fault.getName());
                    if (fault.getElement() != null && fault.getElement().getQName().equals(qName)) {
                        bPELException = new UserDefinedException(qName3, null, fault, scope);
                        bPELException.setName(qName3.toString());
                        bPELException.setFault((Message)((BPELInternalMessage)message));
                    } else {
                        if (fault.getMessageName() == null || !qName3.equals(qName)) continue;
                        bPELException = new UserDefinedException(qName3, null, fault, scope);
                        bPELException.setName(qName3.toString());
                        bPELException.setFault((Message)((BPELInternalMessage)message));
                    }
                    break;
                }
            } else {
                bPELException = new TechnicalException(exception);
            }
        } else {
            bPELException = new BPELException((Throwable)exception);
        }
        return bPELException;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

