/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.registry.BPELRegistry;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = BPELRegistry.class))
@Membrane(controller = "primitive")
public class BPELMemoryRegistryImpl extends
AbstractProcessDefinitionRegistry<BPELProcess> implements BPELRegistry {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	// private static final int POOL_SIZE = 5;

	private Logger log = Logger.getLogger(BPELMemoryRegistryImpl.class
			.getName());



	public BPELProcess getProcessDefinition(final ProcessKey name) {
		return (BPELProcess)this.registry.get(name);
	}

	@SuppressWarnings("unchecked")
	public List<BPELProcess> getAllProcessDefinitions() {
		// TODO : same definition is stored with different keys ; it corresponds to number of
		// interafces used in this BPEL.
		return new ArrayList<BPELProcess>((Collection)this.registry.values());
	}

	public BPELProcess removeProcessDefinition(final ProcessKey name,
			final boolean forceUninstall) throws CoreException {
		BPELProcess res = null;
		this.log.finest("Map of instance: "
				+ ((MemoryProcessInstanceRegistryImpl) this.getModel()
						.getCore().getEngine().getProcessInstanceRegistry())
						.getMap());

		// Delete all instances if they are in state ended
		Iterator<Process> it = this.getModel().getCore().getEngine()
		.getProcessInstanceRegistry().getProcessInstances(name)
		.iterator();// getProcessInstances(name).iterator();
		final List<Process> undeleteProcess = new ArrayList<Process>();
		while (it.hasNext()) {
			final Process process = it.next();
			if (forceUninstall) {
				this.log
				.finest("remove process instance: " + process.getName());
				final Process p = this.getModel().getCore().getEngine()
				.getProcessInstanceRegistry().removeProcessInstance(
						process, forceUninstall);
				if (p != null) {
					it = this.getModel().getCore().getEngine()
					.getProcessInstanceRegistry().getProcessInstances(
							name).iterator();
				} else {
					this.log
					.warning("Impossible to delete instance: process is null: "
							+ process.getName());
				}
			} else if (((process.getParentExecution() != null) && (process
					.getParentExecution().getState() == Execution.State.ENDED))
					|| (process.getParentExecution() == null)) {
				this.log
				.finest("remove process instance: " + process.getName());

				final Process p = this.getModel().getCore().getEngine()
				.getProcessInstanceRegistry().removeProcessInstance(
						process, forceUninstall);
				if (p != null) {
					it = this.getModel().getCore().getEngine()
					.getProcessInstanceRegistry().getProcessInstances(
							name).iterator();
				} else {
					this.log
					.warning("Impossible to delete instance, try forceuninstall=true: "
							+ process.getName());
				}
			} else {
				if (!undeleteProcess.contains(process)) {
					undeleteProcess.add(process);
				}
			}
		}

		if (undeleteProcess.size() > 0) {
			// impossible to delete all instance: so, create message and throw
			// corresponding exception
			String errorMsg = "";
			for (final Process process : undeleteProcess) {
				errorMsg = errorMsg
				+ "Impossible to remove this process instance"
				+ process.getName()
				+ " because it is not ended: state = "
				+ process.getParentExecution().getState() + "\n";
			}
			throw new CoreException(errorMsg);
		} else {
			// Delete the definition
			res = (BPELProcess)this.registry.remove(name);
		}
		return res;
	}



	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public List<ProcessKey> createKeys(ProcessDefinition processDefinition)
	throws CoreException {
		BPELProcess bpelDefinition = (BPELProcess) processDefinition;
		final List<ProcessKey> keys = new ArrayList<ProcessKey>();
		List<AbsItfInterfaceType> itfs;
		try {
			itfs = bpelDefinition.getImports().getProcessInterfaces();
			this.log.finest("Number of interfaces exposed by bpel: " + itfs.size());

			for (final AbsItfInterfaceType itf : itfs) {

				if (itf != null) {
					final List<Endpoint> endpoints = bpelDefinition
					.getImports().findEndpointsImplementingInterface(
							(InterfaceType) itf);
					this.log
					.finest("Number of endpoints implementing this interface \"" + itf.getQName() + "\" : " + endpoints.size());
					if ((endpoints != null) && (endpoints.size() >= 1)) {
						for (final Endpoint endpoint : endpoints) {
							this.log.finest(endpoint.getName());
							if (endpoint.getService() != null) {
								keys.add(new ProcessKeyImpl(itf.getQName(),
										endpoint.getService().getQName(),
										endpoint.getName()));
							} else {
								throw new CoreException(
										"Service not found for this endpoint: "
										+ endpoint.getName()
										+ ". An endpoint MUST be associated to a service.");
							}
						}
					} else {
						keys
						.add(new ProcessKeyImpl(itf.getQName(), null,
								null));
					}
				} else {
					keys.add(new ProcessKeyImpl(processDefinition.getQName(),
							null, null));
				}
			}

		} catch (WSDL4BPELException e) {
			throw new CoreException(e);
		}
		return keys;
	}


	@Override
	public <D extends ProcessDefinition> boolean isCreateInstance(D def,
			InternalMessage<?> mess) {

		boolean res = false;
		boolean found = false;

		/*
		 * Retrieve internal message part for matching 
		 */
		QName messageQName = null;
		if(mess != null){
			messageQName = mess.getQName();
		}

		/*
		 * Try to find matching activity : in receives
		 */
		List<Receive> receiveActivities = null;
		if(def instanceof BPELProcess){
			receiveActivities = ScopeImpl.findActivityRecursively(Receive.class, ((BPELProcess)def).getActivity());
			this.log.finest("number of Receives ... "+receiveActivities.size());
		}
		if(receiveActivities != null){
			Iterator<Receive> itReceives = receiveActivities.iterator();
			while(itReceives.hasNext() && !found){

				Receive r = itReceives.next();
				BPELVariable var = ((BPELProcess)def).findVariable(new QName(r.getInputVariable()));
			
				QName varQN = var.getMessageType();
			
				if(varQN == null){
					this.log.finest("messageType is null");
					varQN = ((BPELProcess)def).findVariable(new QName(r.getInputVariable())).getElement();
				}
				String operation = r.getOperation();

				
				this.log.finest("Receive : "+varQN);

				if(findMatchingActivity(varQN, messageQName)){
					res = r.getCreateInstance();
					found = true;
				}

			}

			if(!found){
				/*
				 * Try to find matching activity : in picks
				 */

				List<Pick> pickActivities = null;
				if(def instanceof BPELProcess){
					pickActivities = ScopeImpl.findActivityRecursively(Pick.class, ((BPELProcess)def).getActivity());
				}
				if(pickActivities != null){
					Iterator<Pick> itPicks = pickActivities.iterator();
					while(itPicks.hasNext() && !found){
						Pick pick = itPicks.next();
						Iterator<OnMessage> itOnMessages = pick.getOnMessages().iterator();
						while(itOnMessages.hasNext() && !found){
							OnMessage onM = itOnMessages.next();
							QName varQN = ((BPELProcess)def).findVariable(new QName(onM.getInputVariable())).getMessageType();
							if(varQN == null){
								varQN = ((BPELProcess)def).findVariable(new QName(onM.getInputVariable())).getElement();
							}


							if(findMatchingActivity(varQN, messageQName)){
								res = pick.getCreateInstance();
								found = true;
							}
						}

					}
				}

				if(!found){
					this.log.severe("No matching activity were found for given message "+mess.getQName());
					//TODO Check if the BPEL engine MUST create a new instance by default, when not finding activity
					// corresponding to the message
					//res = true;
				}
			}
		}
		
		return res;
	}

	private boolean findMatchingActivity(QName varQN,
			QName messageQName) {
		boolean res = false;
		//FIXME must be tested on both local part and namespace URI
		if(varQN.getLocalPart().equals(messageQName.getLocalPart())) {
			res = true;
		}

		return res;
	}

}


