/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractOperationImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding.StyleConstant;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.MessageUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageAdapter;

public class SOAPAdapter implements MessageAdapter {

	private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());

	private final Descriptions desc;

	private final BPELProcess bpeldefinition;

	private Endpoint providerEndpoint;

	private static final String REQUEST = "request";
	private static final String RESPONSE = "response";

	public SOAPAdapter(final BPELProcess bpeldefinition, final Endpoint providerEndpoint) {
		this.desc = bpeldefinition.getImports();
		this.bpeldefinition = bpeldefinition;
		this.providerEndpoint = providerEndpoint;
	}

	public SOAPAdapter(final BPELProcess bpeldefinition) {
		this.desc = bpeldefinition.getImports();
		this.bpeldefinition = bpeldefinition;
	}


	public void setLog(final Logger logger) {
		this.log = logger;
	}






	public InternalMessage<?> adapt(final Variable variable)
	throws CoreException {
		InternalMessage msg = null;
		if(this.providerEndpoint == null) {
			throw new CoreException("Provider Endpoint cannot be null");
		}
		// adapt message
		msg = this.format((BPELVariable)variable, this.providerEndpoint);

		return msg;
	}

	private BPELInternalMessage format(final BPELVariable<Element> variable, final Endpoint providerEndpoint) throws CoreException {

		BPELInternalMessage formattedMessage = null;
		// test content
		if(variable.getValue() == null || variable.getValue().getContent() == null) {
			// create empty message
			MessageUtil.createMessageIfNotExist(variable, this.desc, BPELFactoryImpl.getCore().getMessageFactory());

		}

		formattedMessage = (BPELInternalMessage)variable.getValue();
		

		this.log.finest("providerEndpoint.getEndpointName() = " + providerEndpoint.getEndpointName());
		this.log.finest("providerEndpoint.getInterfaceName() = " + providerEndpoint.getInterfaceName());
		this.log.finest("providerEndpoint.getServiceName() = " + providerEndpoint.getServiceName());
		this.log.finest("providerEndpoint.getDescription() = " + providerEndpoint.getDescription());
		if((variable.getValue() != null) && (providerEndpoint.getDescription() != null)) {

			// find the interface corresponding to the operation
			Operation op = null;
			final InterfaceType itf = this.desc.getInterface(providerEndpoint.getInterfaceName());
			op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), providerEndpoint.getInvokedOperation()));

			if(op != null) {
				Binding binding = null;
				for(final Binding bindingItem: (this.desc).getBindings()) {
					if((bindingItem.getInterface() != null) && bindingItem.getInterface().getQName().equals(itf.getQName())) {
						binding = bindingItem;
						break;
					}
				}

				// find the binding operation
				if(binding == null) {
					throw new CoreException("Impossible to find binding corresponding to interface: " + itf.getQName());
				}
				BindingOperation bOp = null;
				for(final BindingOperation bOpItem: binding.getBindingOperations()) {
					if(bOpItem.getQName().getLocalPart().equals(op.getQName().getLocalPart())) {
						bOp = bOpItem;
					}
				}
				
				
				if(bOp != null) {
					System.out.println(bOp.getOperation().getQName());
					System.out.println(bOp.getStyle());
					System.out.println(bOp.getSoapAction());
					
					
					// retrieve the direction
					String direction = REQUEST;
					if((providerEndpoint.getEndpointName() != null) && providerEndpoint.getEndpointName().equals("client")) {
						direction = RESPONSE;
					} 

					

					// find the mode
					if(bOp.getStyle() == StyleConstant.DOCUMENT) {
						this.log.finest("format as document");
						formattedMessage = this.formatAsDocument((BPELInternalMessage)variable.getValue(), op, direction);
					} else if(bOp.getStyle() == StyleConstant.RPC) {
						this.log.finest("format as rpc");
						formattedMessage = this.formatAsRpc((BPELInternalMessage)variable.getValue(), bOp, op, direction);
					}  
				}

			}

			// add qname in external message if not exist
			formattedMessage.setQName(new QName((((BPELInternalMessage)(variable.getValue())).getContent()).getNamespaceURI(), (((BPELInternalMessage)(variable.getValue())).getContent()).getName()));

		}



		return formattedMessage;
	}

	private BPELInternalMessage formatAsRpc(final BPELInternalMessage internalMessage, final BindingOperation bOp, final Operation op, final String direction) throws BPELException {
		final BPELInternalMessage formattedMessage = new BPELInternalMessageImpl();

		if(internalMessage != null) {
			formattedMessage.setEndpoint(internalMessage.getEndpoint());
			formattedMessage.setQName(internalMessage.getQName());
			formattedMessage.setService(internalMessage.getService());

			// change message name by the binding operation name
			final org.jdom.Element elmt = (org.jdom.Element) internalMessage.getContent().clone();

			String operationName = bOp.getQName().getLocalPart();
			if(direction.equals(RESPONSE)) {
				operationName = operationName + "Response";
			} 
			elmt.setName(operationName);

			if(!elmt.getNamespaceURI().equals(bOp.getQName().getNamespaceURI())) {
				elmt.setNamespace(Namespace.getNamespace(bOp.getQName().getNamespaceURI()));
			}

			if(((op.getInput().getParts() != null)&& (op.getInput().getParts().size() > 0)) || op.getInput().getElement() != null) {
				final org.jdom.Document doc = new org.jdom.Document(elmt);
				formattedMessage.setContent(doc.getRootElement());
			}
		} else {
			throw new BPELException("Internal message cannot be null.");
		}

		return formattedMessage;
	}

	
	
	private BPELInternalMessage formatAsDocument(final BPELInternalMessage internalMessage, final Operation op, final String direction) throws BPELException {
		final BPELInternalMessage formattedMessage = new BPELInternalMessageImpl();

		if(internalMessage != null) {
			formattedMessage.setEndpoint(internalMessage.getEndpoint());
			formattedMessage.setQName(internalMessage.getQName());
			formattedMessage.setService(internalMessage.getService());

			// get the child element
			org.jdom.Element elmt = null;
			if((internalMessage.getContent().getChildren() != null) && (internalMessage.getContent().getChildren().size() == 1)
					&& (op.getInput().getMessageName().getLocalPart().equals((internalMessage.getContent()).getName())||
							((op.getOutput() != null) && op.getOutput().getMessageName().getLocalPart().equals((internalMessage.getContent()).getName())))) {
				elmt = (org.jdom.Element) ((org.jdom.Element)internalMessage.getContent().getChildren().get(0)).clone();
			} else {
				elmt = (org.jdom.Element) (internalMessage.getContent()).clone();
			}

			// change root name of elmt if needed
			if(direction.equals(REQUEST)&&(op.getInput() != null)) {
				if((op.getInput().getParts() != null)&& (op.getInput().getParts().size()>0) && (op.getInput().getParts().get(0).getType() != null)&&(op.getInput().getParts().get(0).getPartQName() != null)) {
					elmt.setName(op.getInput().getParts().get(0).getPartQName().getLocalPart());
					//elmt.setNamespace(Namespace.getNamespace(op.getInput().getParts().get(0).getPartQName().getNamespaceURI()));
				}else{
					//TODO Check if we are in WSDL 2.0 (that has got no message (and no part)
				}
			}

			if((elmt.getNamespaceURI() == null) || (elmt.getNamespaceURI().trim().length() == 0)) {
				String prefix = null;

				prefix = ((AbstractInterfaceTypeImpl) (((AbstractOperationImpl)op).getInterface())).getDescription().getNamespaces().getPrefix(op.getQName().getNamespaceURI());
				if((prefix == null) || (prefix.trim().length() == 0)) {
					for(final Namespace ns: (List<Namespace>)elmt.getAdditionalNamespaces()) {
						if(ns.getURI().equals(op.getQName().getNamespaceURI())) {
							prefix = ns.getPrefix();
							break;
						}
					}
				}

				if(prefix != null) {
					elmt.setNamespace(Namespace.getNamespace(prefix, op.getQName().getNamespaceURI()));
				} else {
					elmt.setNamespace(Namespace.getNamespace(op.getQName().getNamespaceURI()));
				}


			}
			if(((op.getInput().getParts() != null)&& (op.getInput().getParts().size() > 0) && (op.getInput().getParts().get(0).getType() != null))) {
				elmt.setNamespace(null);
			}
			if(((op.getInput().getParts() != null)&&(op.getInput().getParts().size() > 0)) || op.getInput().getElement() != null) {
				final org.jdom.Document doc = new org.jdom.Document(elmt);
				formattedMessage.setContent(doc.getRootElement());
			}
		} else {
			throw new BPELException("Internal message cannot be null.");
		}
		return formattedMessage;
	}

	public InternalMessage<?> formatFault(final InternalMessage<?> internalMessage) {
		final BPELInternalMessage res = new BPELInternalMessageImpl();

		// get only part inside the message
		res.setContent(Util.getChildElements((Element) internalMessage.getContent()).get(0));

		res.setEndpoint(internalMessage.getEndpoint());
		res.setOperationName(internalMessage.getOperationName());
		res.setQName(internalMessage.getQName());
		res.setService(internalMessage.getService());
		return res;
	}

	public Element getDetails(final Element fault) {
		Element details = null;

		// soap 1.1
		details = fault.getChild("detail", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/"));
		if(details == null) {
			details = fault.getChild("detail");
		}

		// soap 1.2
		if(details == null) {
			details = fault.getChild("Detail", Namespace.getNamespace("http://www.w3.org/2003/05/soap-envelope"));
		}
		if(details == null) {
			details = fault.getChild("Detail");
		}

		return details;
	}


	public Element createSOAPFault(final Element content) {
		Element soapfault = null;

		//TODO: create soap1.2 fault

		// create soap1.1 fault
		soapfault = new Element("Fault", Namespace.getNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/"));
		final Document doc = new Document(soapfault);
		final Element faultcode = new Element("faultcode");
		faultcode.setText("soap:Server");
		soapfault.addContent(faultcode);

		final Element detail = new Element("detail");
		if(content != null) {
			detail.addContent((Element)content.clone());
		}
		soapfault.addContent(detail);

		return doc.getRootElement();
	}



}
