/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.tools;

import java.io.IOException;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;

public class JDomAnalyzer {


	private Document document;

	public JDomAnalyzer(final InputSource source) throws BPELException {

		final SAXBuilder builder = new SAXBuilder();

		// command line should offer URIs or file names
		try {
			this.document = builder.build(source);

		}
		// indicates a well-formedness error
		catch (final JDOMException e) { 
			throw new BPELException(e);
		}  
		catch (final IOException e) { 
			throw new BPELException(e);
		}  

	}



	public Document getDocument() {
		return this.document;
	}
}
