/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ProcessValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;

public class ProcessValidatorImpl
implements ProcessValidator {
    private BPELProcess process = null;

    public ProcessValidatorImpl(BPELProcess bPELProcess) {
        this.process = bPELProcess;
    }

    public void validate() {
        TProcess tProcess;
        if (this.process.getName() == null || this.process.getName().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => the name of process cannot be null or empty")));
        }
        if (this.process.getTargetNamespace() == null || this.process.getTargetNamespace().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => the targetNamespace of process cannot be null or empty")));
        }
        if ((tProcess = (TProcess)((BPELElementImpl)this.process).getModel()).getSuppressJoinFailure() != null) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the suppressJoinFailure attribute is ignored for the moment"));
        }
        if (tProcess.getExitOnStandardFault() != null) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the exitOnStandardFault attribute is ignored for the moment"));
        }
        if (tProcess.getPartnerLinks() == null || tProcess.getPartnerLinks().getPartnerLink() == null || tProcess.getPartnerLinks().getPartnerLink().size() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => A process MUST have at less one partnerLink")));
        }
        if (tProcess.getVariables() == null || tProcess.getVariables().getVariable() == null || tProcess.getVariables().getVariable().size() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => A process MUST have at less one variable")));
        }
        if (tProcess.getPartnerLinks() != null && tProcess.getPartnerLinks().getPartnerLink() != null && tProcess.getPartnerLinks().getPartnerLink().size() > 0) {
            boolean bl = false;
            for (TPartnerLink tPartnerLink : tProcess.getPartnerLinks().getPartnerLink()) {
                if (tPartnerLink.getMyRole() == null || tPartnerLink.getMyRole().trim().length() <= 0) continue;
                bl = true;
            }
            if (!bl) {
                BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute"));
                BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute")));
            }
        }
        if (tProcess.getMessageExchanges() != null && tProcess.getMessageExchanges().getMessageExchange().size() > 0) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the messageExchanges are not supported for the moment"));
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
        if (tProcess.getEventHandlers() != null && (tProcess.getEventHandlers().getOnEvent().size() > 0 || tProcess.getEventHandlers().getOnAlarm().size() > 0)) {
            BPELStaticAnalysisImpl.getInstance().addInfo((Info)new BPELInfoImpl((BPELElement)this.process, "In process => [BPEL engine restriction] Sorry, but the eventHandler are not supported for the moment"));
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((BPELElement)this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
        }
    }
}

