/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.inout;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.EasyNSFilter;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELJAXBContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELReaderImpl
implements BPELReader {
    private static Logger log = Logger.getLogger(BPELReaderImpl.class.getName());
    private Map<BPELReader.FeatureConstants, Object> features = new HashMap<BPELReader.FeatureConstants, Object>();

    public BPELReaderImpl() throws BPELException {
        try {
            this.features.put(BPELReader.FeatureConstants.VERBOSE, false);
            this.features.put(BPELReader.FeatureConstants.IMPORT_DOCUMENTS, true);
            BPELJAXBContext.getInstance();
        }
        catch (BPELException bPELException) {
            throw new BPELException((Throwable)bPELException);
        }
    }

    public JAXBContext getJaxbContext() throws BPELException {
        return BPELJAXBContext.getInstance().getJaxbContext();
    }

    private TProcess convertStream2Process(Source source) throws BPELException {
        try {
            JAXBElement jAXBElement = this.getJaxbContext().createUnmarshaller().unmarshal(source, TProcess.class);
            return (TProcess)jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new BPELException("Failed to build Java bindings from WSDL descriptor XML document", (Throwable)jAXBException);
        }
    }

    public BPELProcess readBPEL(URI uRI) throws BPELException {
        BPELProcess bPELProcess = null;
        try {
            InputStream inputStream = null;
            File file = new File(uRI.toString());
            inputStream = file.exists() ? new FileInputStream(file) : uRI.toURL().openStream();
            bPELProcess = this.readBPEL(uRI, new InputSource(inputStream));
        }
        catch (MalformedURLException malformedURLException) {
            throw new BPELException("Can not get bpel at: " + uRI, (Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            throw new BPELException("Can not get bpel at: " + uRI, (Throwable)iOException);
        }
        catch (BPELException bPELException) {
            throw new BPELException("Can not get bpel at: " + uRI, (Throwable)bPELException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BPELException("Can not get bpel at: " + uRI, (Throwable)illegalArgumentException);
        }
        return bPELProcess;
    }

    public BPELProcess readBPEL(Document document) throws BPELException {
        BPELProcess bPELProcess = null;
        try {
            URI uRI = null;
            uRI = document.getDocumentURI() != null ? new URI(document.getDocumentURI()) : new File(".").toURI();
            bPELProcess = this.readBPEL(uRI, SourceHelper.convertDOMSource2InputSource((DOMSource)new DOMSource(document)));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new BPELException((Throwable)uRISyntaxException);
        }
        catch (XmlException xmlException) {
            throw new BPELException((Throwable)xmlException);
        }
        return bPELProcess;
    }

    public BPELProcess readBPEL(URI uRI, InputSource inputSource) throws BPELException {
        BPELProcessImpl bPELProcessImpl = null;
        try {
            log.finest("Loading " + uRI);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            EasyNSFilter easyNSFilter = new EasyNSFilter(xMLReader);
            SAXSource sAXSource = new SAXSource((XMLReader)easyNSFilter, inputSource);
            TProcess tProcess = this.convertStream2Process(sAXSource);
            bPELProcessImpl = new BPELProcessImpl(uRI, tProcess, easyNSFilter.getNamespaceMapper(), this.getFeatures());
        }
        catch (SAXException sAXException) {
            throw new BPELException((Throwable)sAXException);
        }
        return bPELProcessImpl;
    }

    public final void setFeature(BPELReader.FeatureConstants featureConstants, Object object) throws BPELException {
        this.features.put(featureConstants, object);
        log.finest("set proterty: " + featureConstants + " - value = " + object);
    }

    public final Object getFeature(BPELReader.FeatureConstants featureConstants) {
        return this.features.get(featureConstants);
    }

    public final Map<BPELReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    public final void setFeatures(Map<BPELReader.FeatureConstants, Object> map) {
        this.features = map;
    }
}

