/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ReplyValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class ReplyValidatorImpl extends ExchangeValidatorImpl<Reply> implements ReplyValidator {

	private static Logger log = Logger.getLogger(ReplyValidatorImpl.class.getName());

	public ReplyValidatorImpl(final Reply reply) {
		super(reply);
	}

	@Override
	public void validate() {
		super.validate();

		// validation
		log.finest("validate reply: " + this.getActivity().getName());
		try {
			// unsupported element
			if((((TReply)((BPELElementImpl)this.getActivity()).getModel()).getToParts() != null) && (((TReply)((BPELElementImpl)this.getActivity()).getModel()).getToParts().getToPart().size() > 0)) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In reply " + this.getActivity().getName() + " => [BPEL engine Restriction] Sorry, but the activity topart is not supported by BPEL engine for the moment. Use assign element before this reply instead"));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => [BPEL engine Restriction] Sorry, but the activity topart is not supported by BPEL engine for the moment. Use assign element before this reply instead")));
			}
			if(((TReply)((BPELElementImpl)this.getActivity()).getModel()).getMessageExchange() != null) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In receive " + this.getActivity().getName() + " => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment."));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => [BPEL engine Restriction] Sorry, but the activity topart is not supported by BPEL engine for the moment. Use assign element before this reply instead")));
			}

			// validation if null or empty
			if((this.getActivity().getPartnerLink() == null) || (this.getActivity().getPartnerLink().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => the partnerLink cannot be null or empty")));
			}
			if((this.getActivity().getOperation() == null) || (this.getActivity().getOperation().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => the operation cannot be null or empty")));
			}
			if((this.getActivity().getOutputVariable() == null) || (this.getActivity().getOutputVariable().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => the output variable cannot be null or empty")));
			}

			// validation if exist

			// find partnerLink
			if((this.getActivity().getPartnerLink() != null) && (this.getActivity().getPartnerLink().trim().length() > 0)) {
				final PartnerLink partnerLink = ScopeUtil.findPartnerLinkRecursively(this.getActivity().getPartnerLink(), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(partnerLink == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => Impossible to find partnerLink corresponding to the name: " + this.getActivity().getPartnerLink())));
				}

				// find operation
				if((this.getActivity().getOperation() != null) && (this.getActivity().getOperation().trim().length() > 0)) {
					if(partnerLink != null) {
						final BPELProcess process = ScopeUtil.getProcess((this.getActivity()));

						final List<AbsItfInterfaceType> itfsToVerify = new ArrayList<AbsItfInterfaceType>();
						if(this.getActivity().getInterface() != null) {
							final InterfaceType itf = process.getImports().getInterface(this.getActivity().getInterface());
							if(itf != null) {
								itfsToVerify.add(itf);
							}
						} else {
							final PartnerLinkType plt = process.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
							if(plt == null) {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In receive " + this.getActivity().getName() + " => Impossible to find partnerLink corresponding to the name: " + partnerLink.getPartnerLinkType())));
							}
							if(plt != null) {
								if(((partnerLink.getMyRole() == null) || (partnerLink.getMyRole().trim().length() == 0))&&
										((partnerLink.getPartnerRole() == null) || (partnerLink.getPartnerRole().trim().length() == 0))) {
									// get all role of partnerLink type
									for(final Role r: plt.getRoles()) {
										itfsToVerify.add(r.getInterface());
									}
								} else {
									if((partnerLink.getMyRole() != null) && (partnerLink.getMyRole().trim().length() > 0)) {
										for(final Role r: plt.getRoles()) {
											if(r.getName().equals(partnerLink.getMyRole())) {
												itfsToVerify.add(r.getInterface());
												break;
											}
										}
									} 
									if((partnerLink.getPartnerRole() != null) && (partnerLink.getPartnerRole().trim().length() > 0)) {
										for(final Role r: plt.getRoles()) {
											if(r.getName().equals(partnerLink.getPartnerRole())) {
												itfsToVerify.add(r.getInterface());
												break;
											}
										}
									}
								}
							}
						}
						final List<AbsItfOperation> ops = new ArrayList<AbsItfOperation>();
						if(itfsToVerify.size() == 0) {
							if(this.getActivity().getInterface() != null) {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the portType: " + this.getActivity().getInterface())));
							} else {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => Impossible to find portType. You must add portType attribute in reply or add a role to the partnerLink of reply")));
							}
						}

						for(final AbsItfInterfaceType itf: itfsToVerify) {
							final AbsItfOperation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.getActivity().getOperation()));
							if(op != null) {
								ops.add(op);
							}
						}

						if(ops.size() == 0) {
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the operation: " + this.getActivity().getOperation())));
						} else if(ops.size() > 1) {
							String itfString = null;
							for(final AbsItfOperation op: ops) {
								if(itfString == null) {
									itfString = ((AbsItfInterfaceType)((AbstractWSDLElementImpl)op).getParent()).getQName().toString();
								} else {
									itfString = itfString + ", " + ((AbsItfInterfaceType)((AbstractWSDLElementImpl)op).getParent()).getQName().toString();
								}
							}
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => Several interfaces match with the operation " + this.getActivity().getOperation() + ": " + itfString + ". " +  "You must add portType attribute in reply or add a role to the partnerLink of reply")));
						}

					}



				}

			}

			// find variable
			if((this.getActivity().getOutputVariable() != null) && (this.getActivity().getOutputVariable().trim().length() > 0)) {
				final BPELVariable var = ScopeImpl.findVariableRecursively(new QName(this.getActivity().getOutputVariable()), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(var == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => Impossible to find output variable corresponding to the name: " + this.getActivity().getOutputVariable())));
				}
			}
		} catch (final WSDL4BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In reply " + this.getActivity().getName() + " => " + e.getMessage())));
		}
	}

}
