/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.correlation;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelationWithPattern;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensibleElements;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInitiate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPattern;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class CorrelationImpl  extends BPELElementImpl<TCorrelation> implements Correlation {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(CorrelationImpl.class.getName());
	
	private final TExtensibleElements parentCorrelationsElmt;
	
	@SuppressWarnings("unchecked")
	public CorrelationImpl(final TCorrelation model, final TExtensibleElements parentCorrelationsElmt, final BPELElement parent) {
		super(Constants._Correlation_QNAME, model, parent);
		this.parentCorrelationsElmt = parentCorrelationsElmt;

	}

	public String getSet() {
		return this.model.getSet();
	}
	
	public TInitiate getInitiate() {
		return this.model.getInitiate();
	}

	public TPattern getPattern() {
		TPattern res = null;
		if(this.model instanceof TCorrelationWithPattern) {
			res = ((TCorrelationWithPattern)this.model).getPattern();
		}
		return res;
	}








}
