/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Document;
import org.jdom.Element;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.TechnicalException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

public class BPELFaultHandler implements FaultHandler {

	private Logger log = Logger.getLogger(BPELFaultHandler.class.getName());

	private final Descriptions desc;

	private final BPELProcess bpeldefinition;

	private final Invoke invoke;
	
	private final SOAPAdapter soapAdapter;

	public BPELFaultHandler(final BPELProcess bpeldefinition, final Invoke invoke) {
		this.desc = bpeldefinition.getImports();
		this.bpeldefinition = bpeldefinition;
		this.invoke = invoke;
		this.soapAdapter = new SOAPAdapter(this.bpeldefinition);
	}

	public boolean match(final Scope scope, final Fault f, final Exception e, final Scope faultScope) throws CoreException {
		boolean res = false;
		try {
			
			if((f.getFaultName() != null) && f.getFaultName().getLocalPart().equals("unknown") && (f.getVariable() == null)) {
				this.log.finest("faultName = " + f.getFaultName());
				res = true;
			} else if(e instanceof CoreException) {
				if(e instanceof UserDefinedException) {
					UserDefinedException businessException = (UserDefinedException) e;
					final BPELVariable var = (BPELVariable) f.getVariable();
					
					if( !res && (var != null) && (var.getElement() != null) &&
							(businessException.getQnameType() == UserDefinedException.FaultQnameType.ELEMENT_QNAME) &&
							var.getElement().equals(businessException.getQname())) {

						final Variable v = faultScope.findVariable(var.getQName());
						final BPELInternalMessage faultMessage = new BPELInternalMessageImpl();

						if(((UserDefinedException)e).getFault() == null) {
							final Variable vf = faultScope.findVariable(new QName(((UserDefinedException)e).getFaultVariableName()));
							final BPELInternalMessage formattedSoapFault = (BPELInternalMessage) (this.soapAdapter).formatFault(vf.getValue());
							final Element soapFault = this.soapAdapter.createSOAPFault(formattedSoapFault.getContent());
							final BPELInternalMessage faultSoap = new BPELInternalMessageImpl();
							faultSoap.setContent(soapFault);
							((UserDefinedException)e).setFault(faultSoap);
						}
						
						final Element detail = this.soapAdapter.getDetails((Element) ((UserDefinedException)e).getFault().getContent());
						final Document doc = new Document((Element) (Util.getChildElements(detail).get(0)).clone());
						faultMessage.setContent(doc.getRootElement());
						faultMessage.setEndpoint(((UserDefinedException)e).getFault().getEndpoint());
						faultMessage.setOperationName(((UserDefinedException)e).getFault().getOperationName());
						faultMessage.setQName(((UserDefinedException)e).getFault().getQName());
						faultMessage.setService(((UserDefinedException)e).getFault().getService());
						v.setValue(faultMessage);

						res = true;
					}
					else if( !res && (var != null) && (var.getMessageType() != null) && 
						(businessException.getQnameType() == UserDefinedException.FaultQnameType.MESSAGE_QNAME) &&
						var.getMessageType().equals(businessException.getQname())) {
						
						final Variable v = faultScope.findVariable(var.getQName());
						final BPELInternalMessage faultMessage = new BPELInternalMessageImpl();
						if(businessException.getFault() == null) {
							final Variable vf = faultScope.findVariable(new QName(businessException.getFaultVariableName()));
							final BPELInternalMessage formattedSoapFault = (BPELInternalMessage) (this.soapAdapter).formatFault(vf.getValue());
							final Element soapFault = this.soapAdapter.createSOAPFault(formattedSoapFault.getContent());
							final BPELInternalMessage faultSoap = new BPELInternalMessageImpl();
							faultSoap.setContent(soapFault);
							
							businessException.setFault(faultSoap);
						}
						
						final Element detail = this.soapAdapter.getDetails((Element) businessException.getFault().getContent());
						final Document doc = new Document((Element) (Util.getChildElements(detail).get(0)).clone());
						faultMessage.setContent(doc.getRootElement());
						faultMessage.setEndpoint(businessException.getFault().getEndpoint());
						faultMessage.setOperationName(businessException.getFault().getOperationName());
						faultMessage.setQName(businessException.getFault().getQName());
						faultMessage.setService(businessException.getFault().getService());
						v.setValue(faultMessage);

						res = true;
					}
				}
				
				if( !res && (f.getFaultName() != null) && f.getFaultName().toString().equals(((CoreException)e).getName())) {
					res = true;
				} 
				if( !res && (f.getVariable().getQName() != null) && f.getVariable().getQName().toString().equals(((CoreException)e).getName())) {
					res = true;
				}
			}
		} catch(final BPELException ex) {
			throw new CoreException(e);
		}
		return res;
	}



	public BPELException getModelExceptionFromGenericException(
			final Scope scope, final Exception e) throws CoreException {
		BPELException res = null;
		assert (e instanceof CoreException);
		CoreException ce = (CoreException) e;

		if (this.invoke == null) {
			throw new CoreException("Invoke cannot be null");
		}
		if (this.bpeldefinition == null) {
			throw new CoreException("BPEL definition cannot be null");
		}

		final Message fault = ((CoreException) e).getFault();
		if (!(fault instanceof BPELInternalMessage)) {
			throw new CoreException("Impossible to understand the fault: "
					+ fault + " => " + e.getMessage(), e);
		}
		final Element details = this.soapAdapter
				.getDetails(((BPELInternalMessage) fault).getContent());
		if ((details != null) && (details.getChildren().size() > 1)) {
			throw new CoreException(
					"Sorry, but the management of severals faults is not supported");
		}
		if ((details != null) && (Util.getChildElements(details).size() == 1)) {
			final Element elmt = Util.getChildElements(details).get(0);
			final QName faultElement = new QName(elmt.getNamespaceURI(), elmt
					.getName());
			final QName interfaceName = this.invoke.getInterface();
			InterfaceType itf = null;
			if (interfaceName != null) {
				itf = this.desc.getInterface(interfaceName);
			} else {
				PartnerLink partnerLink = bpeldefinition
						.findPartnerLink(this.invoke.getPartnerLink());
				PartnerLinkType partnerLinkType = null;
				try {
					partnerLinkType = bpeldefinition.getImports()
							.getPartnerLinkType(
									partnerLink.getPartnerLinkType());
				} catch (WSDL4BPELException w4be) {
					throw new CoreException(
							"Impossible to find partnerLinkType '"
									+ partnerLink.getPartnerLinkType()
									+ "' in imported wsdls.");
				}
				Role partnerLinkRole = partnerLinkType.getRole(partnerLink
						.getPartnerRole());
				itf = partnerLinkRole.getInterface();
			}
			if (itf == null) {
				throw new CoreException("Impossible to find interface '"
						+ interfaceName + "'.");
			}
			final Operation op = itf.getOperation(new QName(itf.getQName()
					.getNamespaceURI(), this.invoke.getOperation()));
			if (op == null) {
				throw new CoreException(
						"Impossible to find operation with this name: "
								+ this.invoke.getOperation());
			}
			final List<org.ow2.easywsdl.wsdl.api.Fault> faults = op.getFaults();
			for (final org.ow2.easywsdl.wsdl.api.Fault faultDef : faults) {
				final QName faultName = new QName(op.getQName()
						.getNamespaceURI(), faultDef.getName());

				// CAUTION : message name must be tested first!! easywsdl
				// assimilate Element taken from
				// message part and element got by resolving its qname ; so if
				// messageName is set, element
				// will ALWAYS be set too...
				if ((faultDef.getMessageName() != null)
						&& ((faultName.equals(faultElement) || ((faultDef
								.getElement() != null) && faultDef.getElement()
								.getQName().equals(faultElement))))) {
					this.log
							.finest("Creating new UserDefinedException from message");

					res = new UserDefinedException(faultName, null,
							UserDefinedException.FaultQnameType.MESSAGE_QNAME,
							faultDef.getMessageName(), scope);

					res.setName(faultName.toString());
					res.setFault(((BPELInternalMessage) fault));
					break;
				} else if ((faultDef.getElement() != null)
						&& (faultDef.getElement().getQName()
								.equals(faultElement))) {
					this.log
							.finest("Creating new UserDefinedException from element");
					res = new UserDefinedException(faultName, null,
							UserDefinedException.FaultQnameType.ELEMENT_QNAME,
							faultDef.getElement().getQName(), scope);
					res.setName(faultName.toString());
					res.setFault(((BPELInternalMessage) fault));
					break;
				}
			}
		} else {
			res = new TechnicalException(ce);
		}

		return res;
	}


	public void setLog(final Logger logger) {
		this.log = logger;
	}

}
