/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;

import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELMessageMatcher implements MessageMatcher {

	private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());

	private final Descriptions desc;

	public BPELMessageMatcher(final Descriptions desc) {
		this.desc = desc;
	}

	public boolean match(final Variable var, final InternalMessage<?> message) throws CoreException {
		boolean res = false;
		if(!(var instanceof BPELVariableImpl)) {
			throw new CoreException("Error: this variable does not correspond to BPEL model");
		}

		final BPELVariableImpl def = (BPELVariableImpl)var;

		if(message.getQName() == null) {
			if((message.getOperationName() != null)&&(message.getService() != null)&&(message.getEndpoint() != null)) {
				
				// get the interface
				final Service service = this.desc.getService(message.getService());
				final Endpoint endpoint = service.getEndpoint(message.getEndpoint());
				final InterfaceType itf = endpoint.getBinding().getInterface();
				final Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), message.getOperationName()));
				if(op == null) {
					throw new CoreException("Impossible to find " + message.getOperationName() + " in wsdl descriptions");
				}
				message.setQName(op.getInput().getMessageName());
				this.log.finest("Message name setted: " + message.getQName());
			} else {
				throw new CoreException("The message has no name");
			}
		}
		
		if((message != null)&&(message.getQName() != null)) {
			// match name
			boolean checkName = false;
			this.log.finest("message.getQName() = " + message.getQName());
			this.log.finest("def.getMessageType() = " + def.getMessageType());
			if((def.getMessageType() != null)&&(def.getMessageType().equals(message.getQName()))) {
				checkName = true;
			}
			if((!checkName)&&((def.getElement() != null)&&(def.getElement().equals(message.getQName())))) {
				checkName = true;
			}
			if((!checkName)&&((def.getQName().getLocalPart() != null)&&(def.getQName().getLocalPart().equals(message.getQName().getLocalPart())))) {
				checkName = true;
			}

			if(checkName) {
				this.log.finest("check on name of message: " + message.getQName() + " is ok for variable " + var.getQName());
				res = true;
			} else {
				this.log.finest("Error: check on name of message: " + message.getQName() + " is not ok for variable " + var.getQName());
			}

			// match type
//			log.finest("var.getType() = " + var.getClass());
//			log.finest("message.getContent().getClass() = " + message.getContent().getClass());
//			if((checkName)&&(var.getType().cast(message.getContent()) != null)) {
//				log.finest("check on type of message: " + message.getQName() + " is ok for variable " + var);
//				res = true;
//			} else {
//				log.finest("Error: check on type of message: " + message.getQName() + " is not ok for variable " + var);
//			}
		} else {
			this.log.finest("the name of message is null: impossible to check for variable " + var);
		}
		return res;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

}
