/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.TechnicalException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

public class BPELFaultHandler
implements FaultHandler {
    private Logger log = Logger.getLogger(BPELFaultHandler.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private final Invoke invoke;
    private final SOAPAdapter soapAdapter;

    public BPELFaultHandler(BPELProcess bpeldefinition, Invoke invoke) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
        this.invoke = invoke;
        this.soapAdapter = new SOAPAdapter(this.bpeldefinition);
    }

    public boolean match(Scope scope, Fault f, Exception e, Scope faultScope) throws CoreException {
        boolean res = false;
        try {
            if (f.getFaultName() != null && f.getFaultName().getLocalPart().equals("unknown") && f.getVariable() == null) {
                this.log.finest("faultName = " + f.getFaultName());
                res = true;
            } else if (e instanceof CoreException) {
                if (e instanceof UserDefinedException) {
                    UserDefinedException businessException = (UserDefinedException)((Object)e);
                    BPELVariable var = (BPELVariable)f.getVariable();
                    if (!res && var != null && var.getElement() != null && businessException.getQnameType() == UserDefinedException.FaultQnameType.ELEMENT_QNAME && var.getElement().equals(businessException.getQname())) {
                        Variable v = faultScope.findVariable(var.getQName());
                        BPELInternalMessageImpl faultMessage = new BPELInternalMessageImpl();
                        if (((UserDefinedException)((Object)e)).getFault() == null) {
                            Variable vf = faultScope.findVariable(new QName(((UserDefinedException)((Object)e)).getFaultVariableName()));
                            BPELInternalMessage formattedSoapFault = (BPELInternalMessage)this.soapAdapter.formatFault(vf.getValue());
                            Element soapFault = SOAPAdapter.createSOAPFault((Element)formattedSoapFault.getContent());
                            BPELInternalMessageImpl faultSoap = new BPELInternalMessageImpl();
                            faultSoap.setContent(soapFault);
                            ((UserDefinedException)((Object)e)).setFault((Message)faultSoap);
                        }
                        Element detail = this.soapAdapter.getDetails((Element)((UserDefinedException)((Object)e)).getFault().getContent());
                        Document doc = new Document((Element)Util.getChildElements(detail).get(0).clone());
                        faultMessage.setContent(doc.getRootElement());
                        faultMessage.setEndpoint(((UserDefinedException)((Object)e)).getFault().getEndpoint());
                        faultMessage.setOperationName(((UserDefinedException)((Object)e)).getFault().getOperationName());
                        faultMessage.setQName(((UserDefinedException)((Object)e)).getFault().getQName());
                        faultMessage.setService(((UserDefinedException)((Object)e)).getFault().getService());
                        v.setValue((InternalMessage)faultMessage);
                        res = true;
                    } else if (!res && var != null && var.getMessageType() != null && businessException.getQnameType() == UserDefinedException.FaultQnameType.MESSAGE_QNAME && var.getMessageType().equals(businessException.getQname())) {
                        Variable v = faultScope.findVariable(var.getQName());
                        BPELInternalMessageImpl faultMessage = new BPELInternalMessageImpl();
                        if (businessException.getFault() == null) {
                            Variable vf = faultScope.findVariable(new QName(businessException.getFaultVariableName()));
                            BPELInternalMessage formattedSoapFault = (BPELInternalMessage)this.soapAdapter.formatFault(vf.getValue());
                            Element soapFault = SOAPAdapter.createSOAPFault((Element)formattedSoapFault.getContent());
                            BPELInternalMessageImpl faultSoap = new BPELInternalMessageImpl();
                            faultSoap.setContent(soapFault);
                            businessException.setFault((Message)faultSoap);
                        }
                        Element detail = this.soapAdapter.getDetails((Element)businessException.getFault().getContent());
                        Document doc = new Document((Element)Util.getChildElements(detail).get(0).clone());
                        faultMessage.setContent(doc.getRootElement());
                        faultMessage.setEndpoint(businessException.getFault().getEndpoint());
                        faultMessage.setOperationName(businessException.getFault().getOperationName());
                        faultMessage.setQName(businessException.getFault().getQName());
                        faultMessage.setService(businessException.getFault().getService());
                        v.setValue((InternalMessage)faultMessage);
                        res = true;
                    }
                }
                if (!res && f.getFaultName() != null && f.getFaultName().toString().equals(((CoreException)((Object)e)).getName())) {
                    res = true;
                }
                if (!res && f.getVariable().getQName() != null && f.getVariable().getQName().toString().equals(((CoreException)((Object)e)).getName())) {
                    res = true;
                }
            }
        }
        catch (BPELException ex) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public BPELException getModelExceptionFromGenericException(Scope scope, Exception e) throws CoreException {
        BPELException res = null;
        assert (e instanceof CoreException);
        CoreException ce = (CoreException)((Object)e);
        if (this.invoke == null) {
            throw new CoreException("Invoke cannot be null");
        }
        if (this.bpeldefinition == null) {
            throw new CoreException("BPEL definition cannot be null");
        }
        Message fault = ((CoreException)((Object)e)).getFault();
        if (!(fault instanceof BPELInternalMessage)) {
            throw new CoreException("Impossible to understand the fault: " + fault + " => " + e.getMessage(), (Throwable)e);
        }
        Element details = this.soapAdapter.getDetails((Element)((BPELInternalMessage)fault).getContent());
        if (details != null && details.getChildren().size() > 1) {
            throw new CoreException("Sorry, but the management of severals faults is not supported");
        }
        if (details != null && Util.getChildElements(details).size() == 1) {
            org.petalslink.abslayer.service.api.Fault[] faults;
            Element elmt = Util.getChildElements(details).get(0);
            QName faultElement = new QName(elmt.getNamespaceURI(), elmt.getName());
            QName interfaceName = this.invoke.getInterface();
            Interface itf = null;
            if (interfaceName != null) {
                itf = this.desc.findInterface(interfaceName);
            } else {
                PartnerLink partnerLink = this.bpeldefinition.findPartnerLink(this.invoke.getPartnerLink());
                PartnerLinkType partnerLinkType = null;
                partnerLinkType = this.bpeldefinition.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
                Role partnerLinkRole = partnerLinkType.getRole(partnerLink.getPartnerRole());
                itf = this.bpeldefinition.getImports().findInterface(partnerLinkRole.getInterfaceQName());
            }
            if (itf == null) {
                throw new CoreException("Impossible to find interface '" + interfaceName + "'.");
            }
            Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.invoke.getOperation()));
            if (op == null) {
                throw new CoreException("Impossible to find operation with this name: " + this.invoke.getOperation());
            }
            org.petalslink.abslayer.service.api.Fault[] faultArray = faults = op.getFaults();
            int n = faults.length;
            int n2 = 0;
            while (n2 < n) {
                org.petalslink.abslayer.service.api.Fault faultDef = faultArray[n2];
                QName faultName = new QName(itf.getQName().getNamespaceURI(), faultDef.getName());
                if (faultDef.getMessageName() != null && (faultName.equals(faultElement) || faultDef.getElementQName() != null && faultDef.getElementQName().equals(faultElement))) {
                    this.log.finest("Creating new UserDefinedException from message");
                    res = new UserDefinedException(faultName, null, UserDefinedException.FaultQnameType.MESSAGE_QNAME, faultDef.getMessageName(), scope);
                    res.setName(faultName.toString());
                    res.setFault((Message)((BPELInternalMessage)fault));
                    break;
                }
                if (faultDef.getElementQName() != null && faultDef.getElementQName().equals(faultElement)) {
                    this.log.finest("Creating new UserDefinedException from element");
                    res = new UserDefinedException(faultName, null, UserDefinedException.FaultQnameType.ELEMENT_QNAME, faultDef.getElementQName(), scope);
                    res.setName(faultName.toString());
                    res.setFault((Message)((BPELInternalMessage)fault));
                    break;
                }
                ++n2;
            }
        } else {
            res = new TechnicalException(ce);
        }
        return res;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

