/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensibleElements;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.CopyImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class AssignImpl extends ActivityImpl<TAssign> implements Assign {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final List<Copy> copy = new ArrayList<Copy>();



	public AssignImpl(final TAssign model, final BPELElement parent)  {
		super(Constants._Assign_QNAME, model, parent);
		for(final TExtensibleElements item: this.model.getCopyOrExtensionAssignOperation()) {
			if(item instanceof TCopy) {
				this.copy.add(new CopyImpl((TCopy) item, this));
			}

			// TODO: Analyze others elements
		}
	}


	public List<Copy> getCopy() {
		return this.copy;
	}
	
	public void addCopy(Copy c) {
		this.copy.add(c);
		this.model.getCopyOrExtensionAssignOperation().add((TExtensibleElements) ((AbstractSchemaElementImpl)c).getModel());
	}


}
