/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCompensate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCompensateScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExit;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TForEach;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRethrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TThrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TValidate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariables;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationSetImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.FaultHandlersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELDateVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELElementVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELLongVariableImpl;
import com.ebmwebsourcing.easyviper.tools.InstanceOfUtil;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ScopeImpl extends ActivityImpl<TScope> implements Scope {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final List<BPELVariable> variables = new ArrayList<BPELVariable>();

	private final List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();

	private final List<CorrelationSet> correlationsets = new ArrayList<CorrelationSet>();

	private FaultHandlers faultHandlers = null;

	private Activity activity;

	public ScopeImpl(final TScope model, final BPELElement parent) {
		super(Constants._Scope_QNAME, model, parent);

		// get partnerLinks
		if(this.model.getPartnerLinks() != null) {
			if((this.model.getPartnerLinks().getPartnerLink() != null)&&
					(this.model.getPartnerLinks().getPartnerLink().size() > 0)) {
				for(final TPartnerLink partner: this.model.getPartnerLinks().getPartnerLink()) {
					this.partnerLinks.add(new PartnerLinkImpl(partner, this.model.getPartnerLinks(), this));
				}
			}
		}

		// get variables
		try {
			this.variables.addAll(ScopeImpl.extractVariablesInModel(this.model.getVariables(), this));
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + e.getMessage(), e)));
		}


		// get correlation set
		try {
			this.correlationsets.addAll(CorrelationSetImpl.extractCorrelationSetsInModel(this.model.getCorrelationSets(), this));
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + e.getMessage(), e)));
		}


		// get activity
		try {
			this.activity = ActivityImpl.analyzeScope(model, this);
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + e.getMessage(), e)));
		} 

		// get faultHandlers
		if(this.model.getFaultHandlers() != null) {
			this.faultHandlers = new FaultHandlersImpl(this.model.getFaultHandlers(), this);
		}
	}





	public void addVariable(final BPELVariable variable) {
		this.variables.add(variable);
	}


	public List<BPELVariable> getVariables() {
		return this.variables;
	}



	public Activity getActivity() {
		return this.activity;
	}


	public PartnerLink getPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink partner: this.partnerLinks) {
			if(partner.getName().equals(name)) {
				res = partner;
				break;
			}
		}
		return res;
	}

	public List<PartnerLink> getPartnerLinks() {
		return this.partnerLinks;
	}

	public CorrelationSet getCorrelationSet(final String name) {
		CorrelationSet res = null;
		for(final CorrelationSet corr: this.correlationsets) {
			if(corr.getName().equals(name)) {
				res = corr;
				break;
			}
		}
		return res;
	}

	public List<CorrelationSet> getCorrelationSets() {
		return this.correlationsets;
	}





	public FaultHandlers getFaultHandlers() {
		return this.faultHandlers;
	}


	public BPELVariable findVariable(final QName name) {
		return ScopeImpl.findVariable(name, this.variables, (BPELElement) this.getParent());
	}
	
	public static BPELVariable findVariable(final QName name, List<BPELVariable> variables, BPELElement parent){
		BPELVariable res = null;
		
		if((variables != null) && (name != null)) {
			for(final BPELVariable var: variables) {
				if((var.getQName() != null) && var.getQName().getLocalPart().equals(name.getLocalPart()) && var.getQName().getNamespaceURI().equals(name.getNamespaceURI())) {
					res = var;
					break;
				}
			}
		}
		if(res == null) {
			res = ScopeImpl.findVariableRecursively(name, parent);
		}
		return res;
	}
	
	public static BPELVariable findVariableRecursively(final QName name, final BPELElement parent) {
		BPELVariable res = null;
		if((name != null) && (parent != null)) {
			if(parent instanceof BPELProcess) {
				res = ((BPELProcess)parent).findVariable(name); 
			} else if(parent instanceof Scope) {
				res = ((Scope)parent).findVariable(name); 
			} else if(parent instanceof ForEach) {
				final ForEach forEach = (ForEach)parent;

				if(forEach.getCounterName().equals(name.getLocalPart())) {
					final TVariable tvar = new TVariable();
					tvar.setName(name.getLocalPart());
					tvar.setType(DefaultSchemaImpl.getInstance().getTypeInt().getQName());
					final TVariables tvars = new TVariables();
					tvars.getVariable().add(tvar);
					final BPELVariable<Integer> var = new BPELIntVariableImpl(tvar, tvars, parent);
					res = var;
				}
			}
			if(res == null) {
				res = ScopeImpl.findVariableRecursively(name, (BPELElement) ((AbstractSchemaElementImpl)parent).getParent()); 
			}
		}
		return res;
	}


//	public <A extends Activity> List<A> findActivity(Class<A> a){
//
//
//		return findActivityRecursively(a, this.getActivity());
//
//
//	}

	public static <A extends Activity> List<A> findActivityRecursively(Class<A> clazz, Activity parent){

		List<A> res = new ArrayList<A>();
		
		if(InstanceOfUtil.isClassExtendOfClass2found(parent.getClass(), clazz)){
		//if(parent.getClass().getName().equals(clazz.getName())) {
			res.add((A) parent);
		} 
		/*
		 * Sequence
		 */
		else if(parent instanceof Sequence) {
			Sequence seq = (Sequence) parent;
			for(Activity a : seq.getActivities()) {
				res.addAll(findActivityRecursively(clazz,a));
			}
		} 
		/*
		 * Flow
		 */
		else if(parent instanceof Flow) {
			Flow f = (Flow) parent;
			for(Activity a: f.getActivities()) {
				res.addAll(findActivityRecursively(clazz, a));
			}
		} 
		/*
		 * RepeatUntil
		 */
		else if(parent instanceof RepeatUntil) {
			RepeatUntil ru = (RepeatUntil) parent;
			res.addAll(findActivityRecursively(clazz, ru.getActivity()));
		} 
		/*
		 * While
		 */
		else if(parent instanceof While) {
			While w = (While) parent;
			res.addAll(findActivityRecursively(clazz, w.getActivity()));
		} 
		/*
		 * ForEach 
		 */
		else if(parent instanceof ForEach) {
			ForEach fe = (ForEach) parent;
			res.addAll(findActivityRecursively(clazz, fe.getScope().getActivity()));
		} 
		/*
		 * If
		 */
		else if(parent instanceof If) {
			If _if = (If) parent;
			for(Activity a: _if.getActivities()){
				res.addAll(findActivityRecursively(clazz, a));
			}
		} 
		/*
		 * Pick
		 */
		else if(parent instanceof Pick) {
			Pick p = (Pick) parent;
			for(OnMessage m: p.getOnMessages()){
				res.addAll(findActivityRecursively(clazz, m.getActivity()));
			}
			//TODO Manage event activities
		}
		/*
		 * Scope
		 */
		else if(parent instanceof Scope) {
			Scope s = (Scope) parent;
			res.addAll(findActivityRecursively(clazz, s.getActivity()));
		}

		return res;

	}


	public PartnerLink findPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink p: this.partnerLinks) {
			if(p.getName().equals(name)) {
				res = p;
				break;
			}
		}
		return res;
	}

	public static List<BPELVariable> extractVariablesInModel(final TVariables variables, final BPELElement parent) throws BPELException {
		final List<BPELVariable> res = new ArrayList<BPELVariable>(); 
		if(variables != null) {
			if((variables.getVariable() != null)&&
					(variables.getVariable().size() > 0)) {
				for(final TVariable variable: variables.getVariable()) {
					if((variable.getType() != null) && variable.getType().equals(DefaultSchemaImpl.getInstance().getTypeInt().getQName())) {
						res.add(new BPELIntVariableImpl(variable, variables, parent));
					} else if((variable.getType() != null) && variable.getType().equals(DefaultSchemaImpl.getInstance().getTypeLong().getQName())) {
						res.add(new BPELLongVariableImpl(variable, variables, parent));
					} else if((variable.getType() != null) && variable.getType().equals(DefaultSchemaImpl.getInstance().getTypeDateTime().getQName())) {
						res.add(new BPELDateVariableImpl(variable, variables, parent));
					} else {
						res.add(new BPELElementVariableImpl(variable, variables, parent));
					}
				}
			}
		}
		return res;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void setActivity(final Activity activity) {
		this.activity = activity;
		
		Object activityModel = ((AbstractSchemaElementImpl)activity).getModel();
		if(activityModel instanceof TAssign){
			this.model.setAssign((TAssign)activityModel);
		}
		else if(activityModel instanceof TCompensate){
			this.model.setCompensate((TCompensate)activityModel);
		}
		else if(activityModel instanceof TCompensateScope){
			this.model.setCompensateScope((TCompensateScope)activityModel);
		}
		else if(activityModel instanceof TEmpty){
			this.model.setEmpty((TEmpty)activityModel);
		}
		else if(activityModel instanceof TExit){
			this.model.setExit((TExit)activityModel);
		}
		else if(activityModel instanceof TExtensionActivity){
			this.model.setExtensionActivity((TExtensionActivity)activityModel);
		}
		else if(activityModel instanceof TFlow){
			this.model.setFlow((TFlow)activityModel);
		}
		else if(activityModel instanceof TForEach){
			this.model.setForEach((TForEach)activityModel);
		}
		else if(activityModel instanceof TIf){
			this.model.setIf((TIf)activityModel);
		}
		else if(activityModel instanceof TInvoke){
			this.model.setInvoke((TInvoke)activityModel);
		}
		else if(activityModel instanceof TPick){
			this.model.setPick((TPick)activityModel);
		}
		else if(activityModel instanceof TReceive){
			this.model.setReceive((TReceive)activityModel);
		}
		else if(activityModel instanceof TRepeatUntil){
			this.model.setRepeatUntil((TRepeatUntil)activityModel);
		}
		else if(activityModel instanceof TReply){
			this.model.setReply((TReply)activityModel);
		}
		else if(activityModel instanceof TRethrow){
			this.model.setRethrow((TRethrow)activityModel);
		}
		else if(activityModel instanceof TScope){
			this.model.setScope((TScope)activityModel);
		}
		else if(activityModel instanceof TSequence){
			this.model.setSequence((TSequence)activityModel);
		}
		else if(activityModel instanceof TThrow){
			this.model.setThrow((TThrow)activityModel);
		}
		else if(activityModel instanceof TValidate){
			this.model.setValidate((TValidate)activityModel);
		}
		else if(activityModel instanceof TWait){
			this.model.setWait((TWait)activityModel);
		}
		else if(activityModel instanceof TWhile){
			this.model.setWhile((TWhile)activityModel);
		}
		else{
			throw new IllegalArgumentException("This activity is not supported : "+activity.getClass().toString());
		}
		
		((AbstractSchemaElementImpl)this.activity).setParent(this);
	}
	
}
