/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CatchValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class ThrowValidatorImpl implements CatchValidator {

	private Throw _throw = null;

	public ThrowValidatorImpl(final Throw _throw) {
		this._throw = _throw;
	}

	public void validate() {
		// validation

		// validation if empty
		if((this._throw.getFaultName() == null) || (this._throw.getFaultName().toString().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._throw, new BPELException("In throw => the faultName cannot be null or empty")));
		}
		if((this._throw.getFaultVariable() != null) && (this._throw.getFaultVariable().toString().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._throw, new BPELException("In throw => the faultVariable cannot be empty")));
		}
		

		//validation on content
		final BPELProcess process = ScopeUtil.getProcess((this._throw));

		
		// find variable
		if((this._throw.getFaultVariable() != null) && (this._throw.getFaultVariable().trim().length() > 0)) {
			final BPELVariable var = ScopeImpl.findVariableRecursively(new QName(this._throw.getFaultVariable()), (BPELElement) ((BPELElementImpl)this._throw).getParent());
			if(var == null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._throw, new BPELException("In throw " + this._throw.getName() + " => Impossible to find fault variable corresponding to the name: " + this._throw.getFaultVariable())));
			}
		}

	}

}
