/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.OnMessageValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;

public class OnMessageValidatorImpl
implements OnMessageValidator {
    private static Logger log = Logger.getLogger(OnMessageValidatorImpl.class.getName());
    private OnMessage message = null;

    public OnMessageValidatorImpl(OnMessage onMessage) {
        this.message = onMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() {
        log.finest("validate onMessage");
        try {
            BPELElement bPELElement;
            if (((TOnMessage)((BPELElementImpl)((Object)this.message)).getModel()).getFromParts() != null && ((TOnMessage)((BPELElementImpl)((Object)this.message)).getModel()).getFromParts().getFromPart().size() > 0) {
                BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead"));
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead")));
            }
            if (((TOnMessage)((BPELElementImpl)((Object)this.message)).getModel()).getMessageExchange() != null) {
                BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment."));
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment.")));
            }
            if (this.message.getPartnerLink() == null || this.message.getPartnerLink().trim().length() == 0) {
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the partnerLink cannot be null or empty")));
            }
            if (this.message.getOperation() == null || this.message.getOperation().trim().length() == 0) {
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the operation cannot be null or empty")));
            }
            if (this.message.getInputVariable() == null || this.message.getInputVariable().trim().length() == 0) {
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the input variable cannot be null or empty")));
            }
            if (this.message.getPartnerLink() != null && this.message.getPartnerLink().trim().length() > 0) {
                bPELElement = ScopeUtil.findPartnerLinkRecursively(this.message.getPartnerLink(), (BPELElement)((Object)((BPELElementImpl)((Object)this.message)).getParent()));
                if (bPELElement == null) {
                    BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find partnerLink corresponding to the name: " + this.message.getPartnerLink())));
                }
                if (this.message.getOperation() != null && this.message.getOperation().trim().length() > 0 && bPELElement != null) {
                    Iterator<Object> iterator;
                    Serializable serializable;
                    BPELProcess bPELProcess = ScopeUtil.getProcess(this.message);
                    ArrayList<WSDLElement> arrayList = new ArrayList<WSDLElement>();
                    if (this.message.getInterface() != null) {
                        serializable = (InterfaceType)bPELProcess.getImports().getInterface(this.message.getInterface());
                        if (serializable != null) {
                            arrayList.add((WSDLElement)serializable);
                        }
                    } else {
                        serializable = bPELProcess.getImports().getPartnerLinkType(bPELElement.getPartnerLinkType());
                        if (!(bPELElement.getMyRole() != null && bPELElement.getMyRole().trim().length() != 0 || bPELElement.getPartnerRole() != null && bPELElement.getPartnerRole().trim().length() != 0)) {
                            for (Role object : serializable.getRoles()) {
                                if (object.getInterface() == null) {
                                    BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType corresponding to role: " + object.getName())));
                                }
                                if (object.getInterface() == null) continue;
                                arrayList.add(object.getInterface());
                            }
                        } else {
                            if (bPELElement.getMyRole() != null && bPELElement.getMyRole().trim().length() > 0) {
                                for (Role role : serializable.getRoles()) {
                                    if (role.getInterface() == null) {
                                        BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType corresponding to role: " + role.getName())));
                                    }
                                    if (!role.getName().equals(bPELElement.getMyRole()) || role.getInterface() == null) continue;
                                    arrayList.add(role.getInterface());
                                    break;
                                }
                            }
                            if (bPELElement.getPartnerRole() != null && bPELElement.getPartnerRole().trim().length() > 0) {
                                for (Role role : serializable.getRoles()) {
                                    if (!role.getName().equals(bPELElement.getPartnerRole())) continue;
                                    arrayList.add(role.getInterface());
                                    break;
                                }
                            }
                        }
                    }
                    serializable = new ArrayList();
                    if (arrayList.size() == 0) {
                        if (this.message.getInterface() != null) {
                            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType: " + this.message.getInterface())));
                        } else {
                            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find portType. You must add portType attribute in receive or add a role to the partnerLink of receive")));
                        }
                    }
                    for (AbsItfInterfaceType absItfInterfaceType : arrayList) {
                        iterator = absItfInterfaceType.getOperation(new QName(absItfInterfaceType.getQName().getNamespaceURI(), this.message.getOperation()));
                        if (iterator == null) continue;
                        serializable.add(iterator);
                    }
                    if (serializable.size() == 0) {
                        BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the operation: " + this.message.getOperation())));
                    } else if (serializable.size() > 1) {
                        void var5_15;
                        Object var5_14 = null;
                        iterator = serializable.iterator();
                        while (iterator.hasNext()) {
                            AbsItfOperation absItfOperation = (AbsItfOperation)iterator.next();
                            if (var5_15 == null) {
                                String string = ((AbsItfInterfaceType)((Object)((AbstractWSDLElementImpl)((Object)absItfOperation)).getParent())).getQName().toString();
                                continue;
                            }
                            String string = String.valueOf(var5_15) + ", " + ((AbsItfInterfaceType)((Object)((AbstractWSDLElementImpl)((Object)absItfOperation)).getParent())).getQName().toString();
                        }
                        BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Several interfaces match with the operation " + this.message.getOperation() + ": " + (String)var5_15 + ". " + "You must add portType attribute in receive or add a role to the partnerLink of receive")));
                    }
                }
            }
            if (this.message.getInputVariable() != null && this.message.getInputVariable().trim().length() > 0 && (bPELElement = ScopeImpl.findVariableRecursively(new QName(this.message.getInputVariable()), (BPELElement)((Object)((BPELElementImpl)((Object)this.message)).getParent()))) == null) {
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find input variable corresponding to the name: " + this.message.getInputVariable())));
            }
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => " + wSDL4BPELException.getMessage())));
        }
    }
}

