/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELMessageMatcher
implements MessageMatcher {
    private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());
    private final Descriptions desc;

    public BPELMessageMatcher(Descriptions descriptions) {
        this.desc = descriptions;
    }

    @Override
    public boolean match(Variable variable, InternalMessage<?> internalMessage) throws CoreException {
        boolean bl = false;
        if (!(variable instanceof BPELVariableImpl)) {
            throw new CoreException("Error: this variable does not correspond to BPEL model");
        }
        BPELVariableImpl bPELVariableImpl = (BPELVariableImpl)variable;
        if (internalMessage.getQName() == null) {
            if (internalMessage.getOperationName() != null && internalMessage.getService() != null && internalMessage.getEndpoint() != null) {
                Service service = (Service)this.desc.getService(internalMessage.getService());
                Endpoint endpoint = (Endpoint)service.getEndpoint(internalMessage.getEndpoint());
                InterfaceType interfaceType = (InterfaceType)((Binding)endpoint.getBinding()).getInterface();
                Operation operation = (Operation)interfaceType.getOperation(new QName(interfaceType.getQName().getNamespaceURI(), internalMessage.getOperationName()));
                if (operation == null) {
                    throw new CoreException("Impossible to find " + internalMessage.getOperationName() + " in wsdl descriptions");
                }
                internalMessage.setQName(((Input)operation.getInput()).getMessageName());
                this.log.finest("Message name setted: " + internalMessage.getQName());
            } else {
                throw new CoreException("The message has no name");
            }
        }
        if (internalMessage != null && internalMessage.getQName() != null) {
            boolean bl2 = false;
            this.log.finest("message.getQName() = " + internalMessage.getQName());
            this.log.finest("def.getMessageType() = " + bPELVariableImpl.getMessageType());
            if (bPELVariableImpl.getMessageType() != null && bPELVariableImpl.getMessageType().equals(internalMessage.getQName())) {
                bl2 = true;
            }
            if (!bl2 && bPELVariableImpl.getElement() != null && bPELVariableImpl.getElement().equals(internalMessage.getQName())) {
                bl2 = true;
            }
            if (!bl2 && bPELVariableImpl.getQName().getLocalPart() != null && bPELVariableImpl.getQName().getLocalPart().equals(internalMessage.getQName().getLocalPart())) {
                bl2 = true;
            }
            if (bl2) {
                this.log.finest("check on name of message: " + internalMessage.getQName() + " is ok for variable " + variable.getQName());
                bl = true;
            } else {
                this.log.finest("Error: check on name of message: " + internalMessage.getQName() + " is not ok for variable " + variable.getQName());
            }
        } else {
            this.log.finest("the name of message is null: impossible to check for variable " + variable);
        }
        return bl;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }
}

