/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.verification;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.api.verification.TypeVerifier;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.util.Util;

public class TypeVerifierImpl
implements TypeVerifier {
    private static Logger log = Logger.getLogger(TypeVerifierImpl.class.getName());
    private final BPELProcess bpelDefinition;

    public TypeVerifierImpl(BPELProcess bpelDefinition) {
        this.bpelDefinition = bpelDefinition;
    }

    @Override
    public Class<?> compare(Element e1, Element e2) throws XPathExpressionException {
        Class res = null;
        if (this.isInteger(e1) && this.isInteger(e2)) {
            res = Integer.class;
        } else if (this.isBoolean(e1) && this.isBoolean(e2)) {
            res = Boolean.class;
        } else if (this.isDateTime(e1) && this.isDateTime(e2)) {
            res = Date.class;
        } else if (this.isString(e1) && this.isString(e2)) {
            res = String.class;
        }
        return res;
    }

    @Override
    public boolean isInteger(Element e) throws XPathExpressionException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace("http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = Util.getPrefix(typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), Util.getLocalPartWithoutPrefix(typeValue));
            }
        } else {
            List<org.ow2.easywsdl.schema.api.Element> elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new XPathExpressionException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() == 1) {
                typeTest = 0;
            } else if (elmts.size() > 1) {
                Iterator<org.ow2.easywsdl.schema.api.Element> it = elmts.iterator();
                org.ow2.easywsdl.schema.api.Element elmt1 = it.next();
                org.ow2.easywsdl.schema.api.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = it.next();
                    if (((Type)elmt1.getType()).getQName() != null && ((Type)elmt1.getType()).getQName().equals(((Type)elmt2.getType()).getQName())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                    ++id;
                }
            }
            type = typeTest >= 0 ? ((Type)elmts.get(typeTest).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type.equals(SchemaFactory.getDefaultSchema().getTypeInt().getQName()) || type.equals(SchemaFactory.getDefaultSchema().getTypeInteger().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is an integer");
            res = true;
        }
        return res;
    }

    @Override
    public boolean isDateTime(Element e) throws XPathExpressionException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace("http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = Util.getPrefix(typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), Util.getLocalPartWithoutPrefix(typeValue));
            }
        } else {
            List<org.ow2.easywsdl.schema.api.Element> elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new XPathExpressionException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() == 1) {
                typeTest = 0;
            } else if (elmts.size() > 1) {
                Iterator<org.ow2.easywsdl.schema.api.Element> it = elmts.iterator();
                org.ow2.easywsdl.schema.api.Element elmt1 = it.next();
                org.ow2.easywsdl.schema.api.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = it.next();
                    if (((Type)elmt1.getType()).getQName() != null && ((Type)elmt1.getType()).getQName().equals(((Type)elmt2.getType()).getQName())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                    ++id;
                }
            }
            type = typeTest >= 0 ? ((Type)elmts.get(typeTest).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type.equals(SchemaFactory.getDefaultSchema().getTypeDateTime().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is an datetime");
            res = true;
        }
        return res;
    }

    @Override
    public boolean isString(Element e) throws XPathExpressionException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace("http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = Util.getPrefix(typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), Util.getLocalPartWithoutPrefix(typeValue));
            }
        } else {
            List<org.ow2.easywsdl.schema.api.Element> elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new XPathExpressionException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() == 1) {
                typeTest = 0;
            } else if (elmts.size() > 1) {
                Iterator<org.ow2.easywsdl.schema.api.Element> it = elmts.iterator();
                org.ow2.easywsdl.schema.api.Element elmt1 = it.next();
                org.ow2.easywsdl.schema.api.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = it.next();
                    if (((Type)elmt1.getType()).getQName() != null && ((Type)elmt1.getType()).getQName().equals(((Type)elmt2.getType()).getQName())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                }
                ++id;
            }
            type = typeTest >= 0 ? ((Type)elmts.get(typeTest).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type.equals(SchemaFactory.getDefaultSchema().getTypeString().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is a string");
            res = true;
        }
        return res;
    }

    @Override
    public boolean isBoolean(Element e) throws XPathExpressionException {
        boolean res = false;
        String typeValue = e.getAttributeValue("type");
        if (typeValue == null) {
            typeValue = e.getAttributeValue("type", Namespace.getNamespace("http://www.w3.org/2001/XMLSchema-instance"));
        }
        QName type = null;
        if (typeValue != null) {
            Namespace ns;
            String prefix = Util.getPrefix(typeValue);
            type = new QName(typeValue);
            if (prefix != null && (ns = e.getNamespace(prefix)) != null) {
                type = new QName(ns.getURI(), Util.getLocalPartWithoutPrefix(typeValue));
            }
        } else {
            List<org.ow2.easywsdl.schema.api.Element> elmts = this.bpelDefinition.getImports().findElementsInAllSchema(new QName(e.getNamespaceURI(), e.getName()));
            if (elmts.size() == 0) {
                if (e.getNamespaceURI() == null || e.getNamespaceURI().equals("")) {
                    log.finest("Element not found in schema. It's probably an unqualified element");
                } else {
                    throw new XPathExpressionException("Element " + e + " not found in all schemas");
                }
            }
            int typeTest = -1;
            if (elmts.size() == 1) {
                typeTest = 0;
            } else if (elmts.size() > 1) {
                Iterator<org.ow2.easywsdl.schema.api.Element> it = elmts.iterator();
                org.ow2.easywsdl.schema.api.Element elmt1 = it.next();
                org.ow2.easywsdl.schema.api.Element elmt2 = null;
                int id = 0;
                while (it.hasNext() && typeTest == -1) {
                    elmt2 = it.next();
                    if (((Type)elmt1.getType()).getQName() != null && ((Type)elmt1.getType()).getQName().equals(((Type)elmt2.getType()).getQName())) {
                        typeTest = id;
                    }
                    elmt1 = elmt2;
                }
                ++id;
            }
            type = typeTest >= 0 ? ((Type)elmts.get(typeTest).getType()).getQName() : SchemaFactory.getDefaultSchema().getTypeString().getQName();
        }
        if (type != null && type.equals(SchemaFactory.getDefaultSchema().getTypeString().getQName())) {
            if (e.getText() != null && (e.getText().trim().equals("true") || e.getText().trim().equals("false"))) {
                log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is a boolean");
                res = true;
            }
        } else if (type != null && type.equals(SchemaFactory.getDefaultSchema().getTypeBoolean().getQName())) {
            log.finest("type: " + new XMLOutputter(Format.getPrettyFormat()).outputString(e) + " is a boolean");
            res = true;
        }
        return res;
    }

    @Override
    public Integer getIntValue(Element e) {
        Integer res = null;
        if (e.getText() != null && e.getText().trim().length() > 0) {
            res = Integer.parseInt(e.getText());
        }
        return res;
    }

    @Override
    public String getStringValue(Element e) {
        return e.getText();
    }

    @Override
    public Boolean getBooleanValue(Element e) {
        Boolean res = null;
        if (e.getText() != null && e.getText().trim().length() > 0) {
            res = Boolean.parseBoolean(e.getText());
        }
        return res;
    }

    @Override
    public Date getDateTimeValue(Element e) throws XPathExpressionException {
        Date res = null;
        if (e.getText() != null && e.getText().trim().length() > 0) {
            try {
                XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(e.getText());
                res = xmlCalendar.toGregorianCalendar().getTime();
            }
            catch (DatatypeConfigurationException e1) {
                throw new XPathExpressionException("Impossible to convert this date: " + e.getText() + " in element: " + e.getName());
            }
            catch (IllegalArgumentException e1) {
                throw new XPathExpressionException("Impossible to convert this date: " + e.getText() + " in element: " + e.getName());
            }
        }
        return res;
    }

    @Override
    public boolean isNullValue(Element e) {
        boolean res = false;
        if (e != null && e.getText() == null) {
            res = true;
        }
        return res;
    }
}

