/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="abstract_service", signature=Behaviour.class)})
@Membrane(controller="primitive")
public abstract class AbstractBehaviourImpl
implements Behaviour,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(AbstractBehaviourImpl.class.getName());
    protected Behaviour.State state = Behaviour.State.ACTIVITY_INACTIVE;
    @Controller
    protected org.objectweb.fractal.api.Component component;

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    @Override
    public String getFcState() {
        return null;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal behaviour created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal behaviour initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal behaviour started: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("behaviour stopped: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal behaviour destroyed: " + this.getName());
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    @Override
    public QName getQName() throws CoreException {
        QName qName = QName.valueOf(this.getName());
        return qName;
    }

    @Override
    public void setQName(QName qName) throws CoreException {
        this.setName(qName.toString());
    }

    protected abstract void executeOnInactive() throws CoreException;

    protected abstract void executeOnStarted() throws CoreException;

    protected abstract void executeOnEnded() throws CoreException;

    @Override
    public void execute() throws CoreException {
        if (this.state == Behaviour.State.ACTIVITY_ENDED) {
            this.log.finest("restart the " + this.getName() + " activity");
            this.state = Behaviour.State.ACTIVITY_INACTIVE;
        }
        this.log.finest("execute the " + this.getName() + " activity on node (" + this.getExecutableElement().getName() + ") by execution (" + this.getExecutableElement().getExecution().getName() + ")");
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE) {
            this.executeOnInactive();
        } else if (this.state == Behaviour.State.ACTIVITY_STARTED) {
            this.executeOnStarted();
        } else if (this.state == Behaviour.State.ACTIVITY_ENDED) {
            this.executeOnEnded();
        }
    }

    @Override
    public abstract ExecutableElement getExecutableElement();

    public String toString() {
        String string = "";
        try {
            string = "behaviour " + this.getName() + " on executable element " + this.getExecutableElement().getName();
        }
        catch (CoreException coreException) {
            string = coreException.getMessage();
        }
        return string;
    }

    @Override
    public Behaviour.State getState() {
        return this.state;
    }

    @Override
    public void setState(Behaviour.State state) {
        this.state = state;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }
}

