/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.fractal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Element;
import com.ebmwebsourcing.easyviper.core.fractal.Binding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.util.Fractal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractalHelper {
    private static final Logger log = Logger.getLogger(FractalHelper.class.getName());
    public static final String EXPLORER_COMPOSITE = "Explorer";
    public static final String CORE_EXPLORER_COMPOSITE = "CoreExplorer";
    public static final String FCAPPL_BINDING = "fcAppl";
    private static FractalHelper fractalHelper;
    private static Map<Object, Object> context;
    private static Factory factory;

    static {
        context = null;
        factory = null;
        System.setProperty("fractal.provider", "org.objectweb.fractal.julia.Julia");
        System.setProperty("julia.loader", "org.objectweb.fractal.julia.loader.DynamicLoader");
        System.setProperty("julia.config", "julia.cfg");
        context = new HashMap<Object, Object>();
        try {
            factory = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend", context);
        }
        catch (ADLException aDLException) {
            log.log(Level.SEVERE, "Impossible to initialize the fractal helper", aDLException);
        }
        fractalHelper = new FractalHelper();
    }

    private FractalHelper() {
    }

    public static FractalHelper getFractalHelper() throws CoreException {
        return fractalHelper;
    }

    public Factory getFactory() throws CoreException {
        if (factory == null) {
            new FractalHelper();
        }
        return factory;
    }

    public synchronized Component createNewComponent(String string, Map<Object, Object> map) throws CoreException {
        try {
            return (Component)this.getFactory().newComponent(string, map);
        }
        catch (ADLException aDLException) {
            throw new CoreException("Impossible to create a new fractal component", aDLException);
        }
    }

    public void changeName(Component component, String string) throws CoreException {
        try {
            NameController nameController = Fractal.getNameController(component);
            nameController.setFcName(string);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to change the name ot this fractal componet: " + component, noSuchInterfaceException);
        }
    }

    public String getName(Component component) {
        String string = null;
        try {
            if (component != null) {
                NameController nameController = Fractal.getNameController(component);
                string = nameController.getFcName();
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {}
        return string;
    }

    public List<Component> getComponentsByName(Component component, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        try {
            ContentController contentController = Fractal.getContentController(component);
            ContentController contentController2 = null;
            Component[] componentArray = contentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    Component component2 = componentArray[n2];
                    try {
                        contentController2 = Fractal.getContentController(component2);
                        if (contentController2.getFcSubComponents().length > 0) {
                            arrayList.addAll(this.getComponentsByName(component2, string));
                        }
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {}
                    try {
                        String string2 = Fractal.getNameController(component2).getFcName();
                        if (string2 == null || !string2.equals(string)) break block8;
                        arrayList.add(component2);
                        break;
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {}
                }
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {}
        return arrayList;
    }

    public Component getFirstComponentByName(Component component, String string) {
        List<Component> list = this.getComponentsByName(component, string);
        Component component2 = null;
        if (list != null && list.size() > 0) {
            component2 = list.get(0);
        }
        return component2;
    }

    public Component getComponentByInterface(Component component, Interface interface_, String string) {
        Component component2 = null;
        try {
            ContentController contentController = Fractal.getContentController(component);
            ContentController contentController2 = null;
            Component[] componentArray = contentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    Component component3;
                    block7: {
                        component3 = componentArray[n2];
                        try {
                            contentController2 = Fractal.getContentController(component3);
                            if (contentController2.getFcSubComponents().length <= 0 || (component2 = this.getComponentByInterface(component3, interface_, string)) == null) break block7;
                            break;
                        }
                        catch (NoSuchInterfaceException noSuchInterfaceException) {
                            component2 = null;
                        }
                    }
                    try {
                        Interface interface_2 = (Interface)component3.getFcInterface(string);
                        if (interface_2 != interface_) break block9;
                        component2 = component3;
                        break;
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {
                        component2 = null;
                    }
                }
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            component2 = null;
        }
        return component2;
    }

    public List<Component> getComponents(Component component) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        try {
            ContentController contentController = Fractal.getContentController(component);
            Component[] componentArray = contentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                arrayList.add(component2);
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {}
        return arrayList;
    }

    public Map<String, Interface> getServerInterfacesLinkedToClientInterfacesOfComponent(Component component) {
        HashMap<String, Interface> hashMap = new HashMap<String, Interface>();
        try {
            BindingController bindingController = Fractal.getBindingController(component);
            String[] stringArray = bindingController.listFc();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                Interface interface_ = (Interface)bindingController.lookupFc(string);
                hashMap.put(string, interface_);
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {}
        return hashMap;
    }

    public List<Component> getClientComponentsLinkedToServerInterfacesOfComponent(Component component, Interface interface_) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        try {
            ContentController contentController = Fractal.getContentController(component);
            Component[] componentArray = contentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                Map<String, Interface> map = FractalHelper.getFractalHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(component2);
                for (Interface interface_2 : map.values()) {
                    if (interface_2 != interface_ || arrayList.contains(component2)) continue;
                    arrayList.add(component2);
                }
                ++n2;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return arrayList;
    }

    public LifeCycleController getLifeCycleControllerByName(Component component, String string) throws CoreException {
        LifeCycleController lifeCycleController = null;
        List<Component> list = this.getComponentsByName(component, string);
        if (list != null && list.size() > 1) {
            throw new CoreException("Several component with the same name");
        }
        Component component2 = null;
        component2 = list.get(0);
        if (component2 != null) {
            try {
                lifeCycleController = Fractal.getLifeCycleController(component2);
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                lifeCycleController = null;
            }
        }
        return lifeCycleController;
    }

    public boolean isStarted(Component component) {
        boolean bl = false;
        if (component != null) {
            try {
                LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
                if (lifeCycleController.getFcState() == "STARTED") {
                    bl = true;
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean startComponent(Component component) throws CoreException {
        boolean bl = false;
        if (component != null) {
            try {
                LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
                if (lifeCycleController != null && lifeCycleController.getFcState().equals("STOPPED")) {
                    lifeCycleController.startFc();
                    bl = true;
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException("Impossible to start the component", noSuchInterfaceException);
            }
            catch (IllegalLifeCycleException illegalLifeCycleException) {
                throw new CoreException("Impossible to start the component", illegalLifeCycleException);
            }
        }
        return bl;
    }

    public boolean stopComponent(Component component) throws CoreException {
        boolean bl = false;
        try {
            LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component);
            if (lifeCycleController.getFcState().equals("STARTED")) {
                lifeCycleController.stopFc();
                bl = true;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to stop the component", noSuchInterfaceException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new CoreException("Impossible to stop the component", illegalLifeCycleException);
        }
        return bl;
    }

    public void stopAllSubComponents(Component component) throws CoreException {
        try {
            ContentController contentController = null;
            ContentController contentController2 = Fractal.getContentController(component);
            int n = contentController2.getFcSubComponents().length;
            while (n != 0) {
                block7: {
                    Component component2 = contentController2.getFcSubComponents()[n - 1];
                    try {
                        contentController = Fractal.getContentController(component2);
                        if (contentController.getFcSubComponents().length > 0) {
                            this.stopAllSubComponents(component2);
                        }
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {
                        LifeCycleController lifeCycleController = Fractal.getLifeCycleController(component2);
                        if (!lifeCycleController.getFcState().equals("STARTED")) break block7;
                        lifeCycleController.stopFc();
                    }
                }
                --n;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to stop the component", noSuchInterfaceException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new CoreException("Impossible to stop the component", illegalLifeCycleException);
        }
    }

    public void addComponent(Component component, Component component2, List<Binding> list) throws CoreException {
        try {
            if (component2 == null) {
                throw new NullPointerException("The parent component of " + component + " cannot be null");
            }
            ContentController contentController = Fractal.getContentController(component2);
            contentController.addFcSubComponent(component);
            FractalHelper.getFractalHelper().addBindings(component, list);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to add a new fractal component", noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new CoreException("Impossible to add a new fractal component", illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new CoreException("Impossible to add a new fractal component", illegalLifeCycleException);
        }
    }

    public synchronized void deleteComponent(Component component) throws CoreException {
        block11: {
            try {
                Object object;
                Component component2 = this.getParent(component);
                if (component2 == null) break block11;
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                BindingController bindingController = Fractal.getBindingController(component);
                Object object2 = bindingController.listFc();
                int n = ((String[])object2).length;
                int n2 = 0;
                while (n2 < n) {
                    object = object2[n2];
                    try {
                        bindingController.unbindFc((String)object);
                    }
                    catch (IllegalBindingException illegalBindingException) {}
                    ++n2;
                }
                object = this.getClientComponentsLinkedToServerInterfacesOfComponent(component2, (Interface)component.getFcInterface("service"));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Component component3 = (Component)iterator.next();
                    object2 = Fractal.getBindingController(component3);
                    String[] stringArray = object2.listFc();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray[n4];
                        if (object2.lookupFc(string) == (Interface)component.getFcInterface("service")) {
                            try {
                                object2.unbindFc(string);
                            }
                            catch (IllegalBindingException illegalBindingException) {}
                        }
                        ++n4;
                    }
                }
                this.deleteComponent(component, component2, arrayList);
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException("Impossible to delete component", noSuchInterfaceException);
            }
            catch (IllegalLifeCycleException illegalLifeCycleException) {
                throw new CoreException("Impossible to delete component", illegalLifeCycleException);
            }
        }
    }

    public synchronized void deleteComponent(Component component, Component component2, List<Binding> list) throws CoreException {
        try {
            if (component2 == null) {
                throw new NullPointerException("The parent component " + component + " cannot be null");
            }
            ContentController contentController = Fractal.getContentController(component2);
            if (FractalHelper.getFractalHelper().isStarted(component)) {
                FractalHelper.getFractalHelper().stopComponent(component);
            }
            FractalHelper.getFractalHelper().deleteBindings(component, list);
            contentController.removeFcSubComponent(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to remove the fractal component", noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new CoreException("Impossible to remove the fractal component", illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new CoreException("Impossible to remove the fractal component", illegalLifeCycleException);
        }
    }

    public void addBindings(Component component, List<Binding> list) throws CoreException {
        try {
            BindingController bindingController = Fractal.getBindingController(component);
            if (list != null) {
                int n = 0;
                while (n < list.size()) {
                    bindingController.bindFc(list.get(n).getClientInterfaceName(), list.get(n).getServerInterface());
                    ++n;
                }
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to bind the fractal component", noSuchInterfaceException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new CoreException("Impossible to bind the fractal component", illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new CoreException("Impossible to bind the fractal component", illegalBindingException);
        }
    }

    public boolean isBinded(Component component, String string) throws CoreException {
        boolean bl = true;
        try {
            BindingController bindingController = Fractal.getBindingController(component);
            Element element = (Element)bindingController.lookupFc(string);
            if (element == null) {
                bl = false;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to bind the fractal component", noSuchInterfaceException);
        }
        return bl;
    }

    public boolean isAlreadyBind(Component component, String string, Interface interface_) throws CoreException {
        try {
            BindingController bindingController = Fractal.getBindingController(component);
            Interface interface_2 = (Interface)bindingController.lookupFc(string);
            return interface_2 == interface_;
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to get the interface", noSuchInterfaceException);
        }
    }

    public List<String> getListOfBinds(Component component) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BindingController bindingController = Fractal.getBindingController(component);
            int n = 0;
            while (n < bindingController.listFc().length) {
                arrayList.add(String.valueOf(bindingController.listFc()[n]) + " link to " + bindingController.lookupFc(bindingController.listFc()[n]));
                ++n;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to bind the fractal component", noSuchInterfaceException);
        }
        return arrayList;
    }

    public Component getParent(Component component) throws CoreException {
        Component component2 = null;
        try {
            SuperController superController = Fractal.getSuperController(component);
            Component[] componentArray = superController.getFcSuperComponents();
            if (componentArray.length > 1) {
                throw new CoreException("This component (" + component + ") has several parents: It is a shared component");
            }
            if (componentArray.length == 1) {
                component2 = componentArray[0];
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return component2;
    }

    public void deleteBindings(Component component, List<Binding> list) throws CoreException {
        try {
            BindingController bindingController = Fractal.getBindingController(component);
            if (list != null) {
                int n = 0;
                while (n < list.size()) {
                    bindingController.unbindFc(list.get(n).getClientInterfaceName());
                    ++n;
                }
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to bind the fractal component", noSuchInterfaceException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new CoreException("Impossible to bind the fractal component", illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new CoreException("Impossible to bind the fractal component", illegalBindingException);
        }
    }

    public void deleteAllClientBindingsOfComponent(Component component) throws CoreException {
        Map<String, Interface> map = this.getServerInterfacesLinkedToClientInterfacesOfComponent(component);
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        for (Map.Entry<String, Interface> entry : map.entrySet()) {
            arrayList.add(new Binding(entry.getKey(), entry.getValue()));
        }
        this.deleteBindings(component, arrayList);
    }

    public void deleteLinkWithAnItfClientOfComponent(Component component, String string) throws CoreException {
        Map<String, Interface> map = this.getServerInterfacesLinkedToClientInterfacesOfComponent(component);
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        for (Map.Entry<String, Interface> entry : map.entrySet()) {
            if (!entry.getKey().equals(string)) continue;
            arrayList.add(new Binding(entry.getKey(), entry.getValue()));
            break;
        }
        this.deleteBindings(component, arrayList);
    }

    public Component createExplorer(String string, String string2) throws CoreException {
        Component component = null;
        try {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            hashMap.put("name", string);
            hashMap.put("definition", string2);
            Component component2 = this.createNewComponent("org.objectweb.fractal.explorer.BasicFractalExplorer", hashMap);
            ContentController contentController = Fractal.getContentController(component2);
            Component[] componentArray = contentController.getFcSubComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component3 = componentArray[n2];
                NameController nameController = Fractal.getNameController(component3);
                if (nameController.getFcName().equals(string)) {
                    component = component3;
                }
                ++n2;
            }
            if (component == null) {
                throw new CoreException("Refecrence of FPVM cannot be found");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("Impossible to create the Fractal Explorer", noSuchInterfaceException);
        }
        return component;
    }

    public void createExplorer(Component component, String string, String string2) throws CoreException {
        Component component2 = this.createNewComponent(CORE_EXPLORER_COMPOSITE, null);
        Component component3 = this.getFirstComponentByName(component2, EXPLORER_COMPOSITE);
        this.startComponent(component3);
        this.addComponent(component, component3, null);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("config", "CoreExplorerProperties.xml");
        Component component4 = this.createNewComponent("org.objectweb.fractal.explorer.GenericFractalExplorerImpl", hashMap);
        log.finest("Create the explorer");
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        this.addComponent(component4, component2, arrayList);
    }
}

