/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.ServiceManager;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.tools.PoolOfProcessForkers;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoTrashProcessServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.ServiceManagerImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=Engine.class)})
@Membrane(controller="composite")
public class EngineImpl
implements Engine,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    @Controller
    private org.objectweb.fractal.api.Component component = null;
    private Logger log = Logger.getLogger(EngineImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="externalEnv")
    protected ExternalEnvironment externalEnvironment;
    @Requires(contingency=Contingency.OPTIONAL, name="model")
    private Model model;
    private ProcessInstanceRegistry processInstanceRegistry;
    private Class internalMessageType;
    private ServiceManager serviceManager = new ServiceManagerImpl(this);
    private PoolOfProcessForkers poolOfProcessForkers = new PoolOfProcessForkers();

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
        if (this.model != null) {
            list.add("model");
        }
        if (this.externalEnvironment != null) {
            list.add("externalEnv");
        }
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("model")) {
            return this.model;
        }
        if (string.equals("externalEnv")) {
            return this.externalEnvironment;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    @Override
    public String getFcState() {
        return null;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.equals("model")) {
            this.model = (Model)object;
            return;
        }
        if (string.equals("externalEnv")) {
            this.externalEnvironment = (ExternalEnvironment)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("model")) {
            this.model = null;
            return;
        }
        if (string.equals("externalEnv")) {
            this.externalEnvironment = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal core created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.processInstanceRegistry = new MemoryProcessInstanceRegistryImpl(this);
        this.log.fine("Fractal core initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal core started: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("Fractal core stopped: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal core destroyed: " + this.getName());
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    private org.objectweb.fractal.api.Component createEmptyProcess(String string) throws CoreException {
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().createNewComponent(ProcessImpl.class.getName(), null);
        FractalHelper.getFractalHelper().addComponent(component, this.getComponent(), null);
        try {
            Process process = (Process)component.getFcInterface("/content");
            process.init(component);
            process.setName(string);
            if (!this.log.getName().equals(EngineImpl.class.getName())) {
                process.setLog(this.log);
            }
            this.log.fine("Creation of the fractal process: " + process.getName());
            FractalHelper.getFractalHelper().startComponent(component);
            process = (Process)component.getFcInterface("process");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return component;
    }

    @Override
    public synchronized Process createNewEmptyProcessInstance(QName qName, ProcessDefinition processDefinition) throws CoreException {
        this.log.finest("start createNewEmptyProcessInstance");
        Process process = null;
        this.checkModel();
        org.objectweb.fractal.api.Component component = this.createEmptyProcess(qName.getLocalPart());
        try {
            process = (Process)component.getFcInterface("process");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            this.log.severe(noSuchInterfaceException.getMessage());
            noSuchInterfaceException.printStackTrace();
            throw new CoreException(noSuchInterfaceException);
        }
        if (this.model == null) {
            this.log.finest("store the process instance in registry in instance registry");
            ProcessKeyImpl processKeyImpl = new ProcessKeyImpl(qName, null, null);
            ArrayList<ProcessKey> arrayList = new ArrayList<ProcessKey>(1);
            arrayList.add(processKeyImpl);
            process.setProcessKeys(arrayList);
            this.processInstanceRegistry.storeProcessInstance(processKeyImpl, process);
        } else {
            List<ProcessKey> list = this.model.getRegistry().createKeys(processDefinition);
            this.log.finest("Number of keys: " + list.size());
            for (ProcessKey processKey : list) {
                this.log.finest("key put in process instances map: " + processKey);
                this.getProcessInstanceRegistry().storeProcessInstance(processKey, process);
            }
            process.setProcessKeys(list);
        }
        this.log.finest("end of createNewEmptyProcessInstance");
        return process;
    }

    private void checkModel() throws CoreException {
        try {
            if (this.model == null) {
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
                Core core = (Core)component.getFcInterface("service");
                this.model = core.getModel();
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
    }

    private void checkExternalEnvironment() throws CoreException {
        try {
            if (this.externalEnvironment == null) {
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
                Core core = (Core)component.getFcInterface("service");
                this.externalEnvironment = core.getExternalEnvironment();
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
    }

    @Override
    public synchronized void accept(InternalMessage<?> internalMessage, ExternalContext externalContext) throws CoreException {
        if (this.internalMessageType == null) {
            throw new CoreException("Configuration error: The type of internal message must be setted");
        }
        this.checkModel();
        Execution execution = this.acceptInternalMessage(internalMessage, externalContext);
        if (execution == null) {
            this.log.finest("no process found => store the received message");
            AutoFlushMessageServiceImpl autoFlushMessageServiceImpl = this.serviceManager.getService(AutoFlushMessageServiceImpl.class);
            autoFlushMessageServiceImpl.addMessagesInRegistry(internalMessage, externalContext);
        } else {
            if (execution.getParentScope().getProcess().getExternalContext() == null) {
                this.log.finest("set the context: " + externalContext + " into process instance " + execution.getParentScope().getProcess().getName());
                execution.getParentScope().getProcess().setExternalContext(externalContext);
            }
            Execution execution2 = execution;
            Collection<String> collection = this.getAllActiveThreadNames();
            while (execution2 != null) {
                if (!collection.contains(execution2.hashCode())) {
                    this.log.finest("Spawning (or respawning) thread for execution " + execution2.getName());
                    ThreadRunProcess threadRunProcess = new ThreadRunProcess(execution2, externalContext);
                    threadRunProcess.start();
                }
                execution2 = execution2.getParentExecution();
            }
        }
    }

    private final Collection<String> getAllActiveThreadNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Thread thread : map.keySet()) {
            hashSet.add(thread.getName());
        }
        return hashSet;
    }

    private Execution acceptInternalMessage(InternalMessage<?> internalMessage, ExternalContext externalContext) throws CoreException {
        Process process;
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        if (this.processInstanceRegistry != null) {
            object3 = new ArrayList();
            this.log.finest("try to find an available instance");
            object3 = this.processInstanceRegistry.getProcessInstances(internalMessage);
            if (object3 != null) {
                this.log.finest("number of potential process: " + object3.size());
                object2 = null;
                object = object3.iterator();
                while (object.hasNext()) {
                    process = (Process)object.next();
                    object2 = object2 == null ? process.getName() : String.valueOf(object2) + ", " + process.getName();
                }
                this.log.finest("potential process list : " + (String)object2);
            } else {
                this.log.finest("number of potential process: 0");
            }
            if (object3 != null && object3.size() > 0) {
                object2 = new ArrayList();
                boolean bl = false;
                object = object3.iterator();
                while (object.hasNext()) {
                    Object object5;
                    Process process2 = (Process)object.next();
                    bl = false;
                    try {
                        this.log.finest("test process: " + process2.getName());
                        if (process2.getParentExecution() != null && process2.getParentExecution().getState() == Execution.State.ENDED) {
                            this.log.finest("reinit and restart an older instance: " + process2.getName());
                            process2.end(true);
                            process2.setExternalContext(null);
                            process2.run();
                        } else if (process2.getParentExecution() == null) {
                            this.log.finest("reinit and restart an older instance: " + process2.getName());
                            process2.setExternalContext(null);
                            process2.run();
                        }
                        bl = true;
                    }
                    catch (CoreException coreException) {
                        process2.setState(Process.State.PROCESS_UNSTABLE);
                        object3.remove(process2);
                        object = object3.iterator();
                        object5 = this.serviceManager.getService(AutoTrashProcessServiceImpl.class);
                        object5.addUninstableProcessInstance(process2);
                    }
                    if (!bl) continue;
                    try {
                        object5 = this.injectMessageInProcessInstance(process2, internalMessage, externalContext);
                        if (object5 == null) continue;
                        this.log.finest("available instance found => restart the process " + process2.getName());
                        process2.setState(Process.State.PROCESS_ACTIVE);
                        object5.setStateRecursively(Execution.State.ACTIVE);
                        object2.add(object5);
                        break;
                    }
                    catch (CoreException coreException) {
                        this.log.severe("Error injecting a message in process " + process2.getName() + ": " + coreException.getMessage());
                        coreException.printStackTrace();
                    }
                }
                if (object2.size() > 0) {
                    object4 = (Execution)object2.get(0);
                }
            }
        }
        if (object4 == null) {
            this.log.finest("no available instance found");
            if (this.model != null) {
                object3 = new ProcessKeyImpl();
                object3.setEndpoint(internalMessage.getEndpoint());
                object3.setService(internalMessage.getService());
                object2 = this.model.getRegistry().getProcessDefinition((ProcessKey)object3);
                if (object2 == null) {
                    throw new CoreException("Impossible to find definition corresponding to this key: " + object3);
                }
                if (this.isCreateInstance((ProcessDefinition)object2, internalMessage)) {
                    process = this.model.getCompiler().compile(object2);
                    if (process != null) {
                        this.log.finest("run the process...");
                        process.run();
                        this.log.finest("inject the message in process");
                        object = this.injectMessageInProcessInstance(process, internalMessage, externalContext);
                        if (object != null) {
                            object.setStateRecursively(Execution.State.ACTIVE);
                            object4 = object;
                        }
                    } else {
                        this.log.finest("no process definition found concerned by the received message: " + object3);
                    }
                }
            }
        }
        return object4;
    }

    private Execution injectMessageInProcessInstance(Process process, InternalMessage<?> internalMessage, ExternalContext externalContext) throws CoreException {
        Execution execution = null;
        Map<String, Execution> map = process.getSuspendedExecutions();
        this.log.finest("list of execution to try: " + map);
        for (Execution execution2 : map.values()) {
            try {
                this.log.finest("try to inject message in process " + process.getName() + " using execution " + execution2.getName());
                if (execution2.getCurrentTarget() instanceof Node) {
                    Node node = (Node)execution2.getCurrentTarget();
                    if (node.getBehaviour() instanceof ReceiverBehaviour) {
                        ReceiverBehaviour receiverBehaviour = (ReceiverBehaviour)node.getBehaviour();
                        if (receiverBehaviour.getMessage() == null) {
                            receiverBehaviour.setMessage(internalMessage);
                            this.log.finest("message setted in receive behaviour: " + receiverBehaviour.getName());
                            boolean bl = receiverBehaviour.accept(internalMessage, externalContext);
                            this.log.finest("accepted by receiver: " + receiverBehaviour.getName() + " ? " + bl);
                            if (bl) {
                                execution = execution2;
                                break;
                            }
                            receiverBehaviour.setMessage(null);
                            continue;
                        }
                        this.log.finest("the receiver " + receiverBehaviour.getName() + " already contains a message");
                        continue;
                    }
                    throw new CoreException("Error: the node selected is not concerned by the received message " + node.getBehaviour().getName() + "::" + node.getClass().getCanonicalName());
                }
                throw new CoreException("Error: the execution selected is not concerned by the received message");
            }
            catch (CoreException coreException) {
                this.log.finest("Error in injectMessageInProcessInstance: " + coreException.getMessage());
            }
        }
        return execution;
    }

    @Override
    public void flushMessagesInRegistry() throws CoreException {
        this.log.finest("flush stored messages");
        AutoFlushMessageServiceImpl autoFlushMessageServiceImpl = this.serviceManager.getService(AutoFlushMessageServiceImpl.class);
        autoFlushMessageServiceImpl.flushMessagesInRegistry();
    }

    @Override
    public void setInternalMessageType(Class clazz) {
        this.internalMessageType = clazz;
    }

    @Override
    public Class getInternalMessageType() {
        return this.internalMessageType;
    }

    @Override
    public void sendTo(InternalMessage<?> internalMessage, Endpoint endpoint, ExternalContext externalContext) throws CoreException {
        this.checkExternalEnvironment();
        if (this.externalEnvironment.getSenders() == null || this.externalEnvironment.getSenders().size() <= 0) {
            throw new CoreException("Senders does not exist!!!");
        }
        this.externalEnvironment.getSenders().get(0).sendTo(internalMessage, endpoint, externalContext);
    }

    @Override
    public InternalMessage<?> sendSyncTo(InternalMessage<?> internalMessage, Endpoint endpoint, ExternalContext externalContext) throws CoreException {
        InternalMessage<?> internalMessage2 = null;
        this.checkExternalEnvironment();
        if (this.externalEnvironment.getSenders() == null || this.externalEnvironment.getSenders().size() <= 0) {
            throw new CoreException("Senders does not exist!!!");
        }
        internalMessage2 = this.externalEnvironment.getSenders().get(0).sendSyncTo(internalMessage, endpoint, externalContext);
        return internalMessage2;
    }

    @Override
    public ProcessInstanceRegistry getProcessInstanceRegistry() {
        return this.processInstanceRegistry;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public void deleteProcess(Process process) throws CoreException {
        FractalHelper.getFractalHelper().deleteComponent(process.getComponent());
    }

    @Override
    public Core getCore() throws CoreException {
        Core core = null;
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
            core = (Core)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return core;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private boolean isCreateInstance(ProcessDefinition processDefinition, InternalMessage<?> internalMessage) throws CoreException {
        return this.model.getRegistry().isCreateInstance(processDefinition, internalMessage);
    }

    @Override
    public PoolOfProcessForkers getPoolOfProcessForkers() {
        return this.poolOfProcessForkers;
    }

    private class ThreadRunProcess
    extends Thread {
        private Execution validProcessOrExecution;
        private ExternalContext context;

        public ThreadRunProcess(Execution execution, ExternalContext externalContext) {
            super(String.valueOf(execution.hashCode()));
            this.validProcessOrExecution = execution;
            this.context = externalContext;
        }

        public void run() {
            try {
                if (this.validProcessOrExecution.isStepByStep()) {
                    this.validProcessOrExecution.runStepByStep();
                } else {
                    this.validProcessOrExecution.run();
                }
            }
            catch (Exception exception) {
                if (exception instanceof CoreException) {
                    try {
                        this.validProcessOrExecution.getParentScope().getProcess().getEngine().getCore().getExternalEnvironment().getSenders().get(0).sendTo((CoreException)exception, this.context);
                    }
                    catch (CoreException coreException) {
                        this.validProcessOrExecution.setState(Execution.State.ENDED);
                        try {
                            this.validProcessOrExecution.end();
                        }
                        catch (CoreException coreException2) {
                            coreException.printStackTrace();
                            EngineImpl.this.log.severe(coreException.getMessage());
                        }
                        coreException.printStackTrace();
                        EngineImpl.this.log.severe(coreException.getMessage());
                    }
                }
                exception.printStackTrace();
                EngineImpl.this.log.severe(exception.getMessage());
            }
        }
    }
}

