/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.FractalComponent;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.FunctionnalBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutableElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Cardinality;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="service", signature=Node.class)})
@Membrane(controller="primitive")
public class NodeImpl
extends ExecutableElementImpl
implements Node,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(NodeImpl.class.getName());
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="childNodes")
    protected Map<String, Node> childNodes = Collections.synchronizedMap(new TreeMap());
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="incomingTransitions")
    protected Map<String, Transition> incomingTransitions = Collections.synchronizedMap(new TreeMap());
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="outgoingTransitions")
    protected Map<String, Transition> outgoingTransitions = Collections.synchronizedMap(new TreeMap());
    @Requires(contingency=Contingency.OPTIONAL, name="behaviour")
    protected FunctionnalBehaviour behaviour;
    @Requires(contingency=Contingency.OPTIONAL, name="parentNode")
    private Node parentNode;
    @Requires(contingency=Contingency.OPTIONAL, name="execution")
    protected Execution execution;
    @Controller
    private org.objectweb.fractal.api.Component component;

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
        if (this.execution != null) {
            list.add("execution");
        }
        if (this.parentNode != null) {
            list.add("parentNode");
        }
        if (this.behaviour != null) {
            list.add("behaviour");
        }
        list.addAll((Collection<String>)this.outgoingTransitions.keySet());
        list.addAll((Collection<String>)this.incomingTransitions.keySet());
        list.addAll((Collection<String>)this.childNodes.keySet());
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("execution")) {
            return this.execution;
        }
        if (string.equals("parentNode")) {
            return this.parentNode;
        }
        if (string.equals("behaviour")) {
            return this.behaviour;
        }
        if (string.startsWith("outgoingTransitions")) {
            return this.outgoingTransitions.get(string);
        }
        if (string.startsWith("incomingTransitions")) {
            return this.incomingTransitions.get(string);
        }
        if (string.startsWith("childNodes")) {
            return this.childNodes.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    @Override
    public String getFcState() {
        return null;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.equals("execution")) {
            this.execution = (Execution)object;
            return;
        }
        if (string.equals("parentNode")) {
            this.parentNode = (Node)object;
            return;
        }
        if (string.equals("behaviour")) {
            this.behaviour = (FunctionnalBehaviour)object;
            return;
        }
        if (string.startsWith("outgoingTransitions")) {
            this.outgoingTransitions.put(string, (Transition)object);
            return;
        }
        if (string.startsWith("incomingTransitions")) {
            this.incomingTransitions.put(string, (Transition)object);
            return;
        }
        if (string.startsWith("childNodes")) {
            this.childNodes.put(string, (Node)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("execution")) {
            this.execution = null;
            return;
        }
        if (string.equals("parentNode")) {
            this.parentNode = null;
            return;
        }
        if (string.equals("behaviour")) {
            this.behaviour = null;
            return;
        }
        if (string.startsWith("outgoingTransitions")) {
            this.outgoingTransitions.remove(string);
            return;
        }
        if (string.startsWith("incomingTransitions")) {
            this.incomingTransitions.remove(string);
            return;
        }
        if (string.startsWith("childNodes")) {
            this.childNodes.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal node created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal node initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal node started: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("node " + this.getName() + " is stopping... ");
        if (this.childNodes != null && this.childNodes.size() > 0) {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
            for (Node node : this.getChildNodes()) {
                this.log.finest("stop child node: " + this.getName());
                org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(component, (Interface)((Object)node), "service");
                if (component2 == null || !FractalHelper.getFractalHelper().isStarted(component2)) continue;
                FractalHelper.getFractalHelper().stopComponent(component2);
            }
        }
        this.log.finest("node stopped: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal node destroyed: " + this.getName());
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    @Override
    public void setActivity(FunctionnalBehaviour functionnalBehaviour) {
        this.behaviour = functionnalBehaviour;
    }

    public Behaviour getActivity() {
        return this.behaviour;
    }

    @Override
    public void execute() throws CoreException {
        block7: {
            try {
                if (this.behaviour == null) break block7;
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.execution.getParentScope().getComponent(), (Interface)((Object)this.behaviour), "service");
                if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
                    FractalHelper.getFractalHelper().startComponent(component);
                }
                try {
                    this.behaviour.execute();
                }
                catch (CoreException coreException) {
                    Scope scope = this.getExecution().getParentScope();
                    Scope scope2 = this.findFaultScope(scope, coreException);
                    if (scope2 == null || scope2.isFaultScope() != null) {
                        this.log.finest("fault not catched: " + coreException.getClass().getName());
                        this.execution.setState(Execution.State.ENDED);
                        throw coreException;
                    }
                    this.log.finest("fault catched by scope: " + scope2.getName());
                    scope2.setFaultScope(coreException);
                    if (scope2.getParentScope().getName().equals(this.execution.getParentScope().getName())) {
                        this.getExecution().setNextExecutableElements((FractalComponent)this, (Node)scope2.getComponent().getFcInterface("service"));
                    }
                    this.execution.setState(Execution.State.ENDED);
                    scope2.getParentScope().linkedExecution2ExecutableElement(scope2.getParentScope().getExecution(), scope2);
                    scope2.getParentScope().linkedExecutableElement2Execution(scope2, scope2.getParentScope().getExecution());
                    scope2.execute();
                }
                this.log.finest("State of behaviour's node: " + this.getName() + " => " + (Object)((Object)this.getBehaviour().getState()));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException(noSuchInterfaceException);
            }
        }
    }

    private Scope findFaultScope(Scope scope, Exception exception) throws CoreException {
        Scope scope2 = null;
        Exception exception2 = null;
        Scope scope3 = scope;
        while (exception2 == null && scope3 != null) {
            exception2 = scope3.isFaultScope();
            scope3 = scope3.getParentScope();
        }
        if (exception2 == null) {
            for (Map.Entry<Fault, Scope> entry : scope.getExceptions().entrySet()) {
                if (entry.getKey().getFaultHandler() == null || !entry.getKey().getFaultHandler().match(scope, entry.getKey(), exception, entry.getValue())) continue;
                scope2 = entry.getValue();
                break;
            }
            if (scope2 == null && scope.getParentScope() != null) {
                scope2 = this.findFaultScope(scope.getParentScope(), exception);
            }
        }
        return scope2;
    }

    @Override
    public void selectDefaultNextTarget() throws CoreException {
        this.log.finest("select default next target");
        if (!this.getExecution().hasNextExecutableElement()) {
            List<Transition> list = this.getOutgoingTransitions();
            this.log.finest("list of following transition: " + list);
            this.log.finest("this.getParentNode(): " + this.getParentNode());
            this.log.finest("this.getExecution(): " + this.getExecution());
            if (list.size() == 1) {
                this.getExecution().setNextExecutableElements((FractalComponent)this, list);
            } else if (this.getParentNode() != null) {
                this.log.finest("this.getParentNode().getExecution(): " + this.getParentNode().getExecution());
                if (this.getExecution().getParentExecution() != null) {
                    if (this.getParentNode().getExecution() == this.getExecution()) {
                        this.log.finest("parent node is next target: " + this.getParentNode().getName());
                        this.getExecution().setNextExecutableElements((FractalComponent)this, this.getParentNode());
                    } else {
                        this.getExecution().setNextExecutableElements((FractalComponent)this, Collections.EMPTY_LIST);
                    }
                } else {
                    this.log.finest("parent node is next target: " + this.getParentNode().getName());
                    this.getExecution().setNextExecutableElements((FractalComponent)this, this.getParentNode());
                }
            } else {
                this.getExecution().setNextExecutableElements((FractalComponent)this, Collections.EMPTY_LIST);
            }
        }
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    @Override
    public Execution getExecution() {
        return this.execution;
    }

    @Override
    public List<Node> getChildNodes() {
        return new ArrayList<Node>(this.childNodes.values());
    }

    @Override
    public FunctionnalBehaviour getBehaviour() {
        return this.behaviour;
    }

    public String toString() {
        String string = "";
        try {
            string = "node " + this.getName();
        }
        catch (CoreException coreException) {
            string = coreException.getMessage();
        }
        return string;
    }

    @Override
    public List<Transition> getIncomingTransitions() {
        return new ArrayList<Transition>(this.incomingTransitions.values());
    }

    @Override
    public List<Transition> getOutgoingTransitions() {
        return new ArrayList<Transition>(this.outgoingTransitions.values());
    }

    @Override
    public Map<String, Transition> getMapOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    @Override
    public Map<String, Transition> getMapIncomingTransitions() {
        return this.incomingTransitions;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public void setExecution(Execution execution) {
        this.execution = execution;
    }
}

