/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.FractalComponent;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.nonfunctionnal.NonFunctionnalBehaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutableElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Cardinality;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="service", signature=Transition.class)})
@Membrane(controller="primitive")
public class TransitionImpl
extends ExecutableElementImpl
implements Transition,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(TransitionImpl.class.getName());
    @Requires(contingency=Contingency.MANDATORY, name="source")
    private Node source;
    @Requires(contingency=Contingency.OPTIONAL, name="destination")
    private Node destination;
    @Requires(contingency=Contingency.OPTIONAL, name="execution")
    private Execution execution;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="nonfunctionalbehaviours")
    private Map<String, NonFunctionnalBehaviour> nonfunctionalbehaviours = Collections.synchronizedMap(new TreeMap());
    @Controller
    private org.objectweb.fractal.api.Component component;
    private ExecutorService execBehaviours = Executors.newCachedThreadPool();

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
        list.addAll((Collection<String>)this.nonfunctionalbehaviours.keySet());
        if (this.execution != null) {
            list.add("execution");
        }
        if (this.destination != null) {
            list.add("destination");
        }
        if (this.source != null) {
            list.add("source");
        }
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith("nonfunctionalbehaviours")) {
            return this.nonfunctionalbehaviours.get(string);
        }
        if (string.equals("execution")) {
            return this.execution;
        }
        if (string.equals("destination")) {
            return this.destination;
        }
        if (string.equals("source")) {
            return this.source;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    @Override
    public String getFcState() {
        return null;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.startsWith("nonfunctionalbehaviours")) {
            this.nonfunctionalbehaviours.put(string, (NonFunctionnalBehaviour)object);
            return;
        }
        if (string.equals("execution")) {
            this.execution = (Execution)object;
            return;
        }
        if (string.equals("destination")) {
            this.destination = (Node)object;
            return;
        }
        if (string.equals("source")) {
            this.source = (Node)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith("nonfunctionalbehaviours")) {
            this.nonfunctionalbehaviours.remove(string);
            return;
        }
        if (string.equals("execution")) {
            this.execution = null;
            return;
        }
        if (string.equals("destination")) {
            this.destination = null;
            return;
        }
        if (string.equals("source")) {
            this.source = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal transition created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal transition initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal transition started: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("transition stopped: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal transition destroyed: " + this.getName());
        this.execBehaviours.shutdown();
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    @Override
    public Node getDestination() {
        return this.destination;
    }

    public Node getSource() {
        return this.source;
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    @Override
    public void execute() throws CoreException {
        for (NonFunctionnalBehaviour nonFunctionnalBehaviour : this.nonfunctionalbehaviours.values()) {
            if (nonFunctionnalBehaviour == null) continue;
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.execution.getParentScope().getComponent(), (Interface)((Object)nonFunctionnalBehaviour), "service");
            if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
                FractalHelper.getFractalHelper().startComponent(component);
            }
            this.execBehaviours.submit(nonFunctionnalBehaviour);
        }
    }

    @Override
    public void selectDefaultNextTarget() throws CoreException {
        if (this.getExecution().hasNextExecutableElement()) {
            return;
        }
        this.getExecution().setNextExecutableElements((FractalComponent)this, this.destination);
    }

    @Override
    public Execution getExecution() {
        return this.execution;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public Map<String, NonFunctionnalBehaviour> getBehaviours() {
        return this.nonfunctionalbehaviours;
    }

    @Override
    public void setBehaviours(Map<String, NonFunctionnalBehaviour> map) {
        this.nonfunctionalbehaviours = map;
    }
}

