/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.DefaultSchema;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;
import org.ow2.easywsdl.schema.impl.SchemaReaderImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;

public final class DefaultSchemaImpl
implements DefaultSchema {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DefaultSchemaImpl.class.getName());
    private static AbsItfSchema defaultSchema = null;
    private static final DefaultSchemaImpl INSTANCE;

    private DefaultSchemaImpl() {
    }

    public static DefaultSchema getInstance() {
        return INSTANCE;
    }

    @Override
    public Type getTypeInt() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
    }

    @Override
    public Type getTypeString() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
    }

    @Override
    public Type getTypeDateTime() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
    }

    @Override
    public Type getTypeBoolean() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
    }

    @Override
    public List<Type> getTypes() {
        List res = null;
        if (defaultSchema != null) {
            res = defaultSchema.getTypes();
        }
        return res;
    }

    @Override
    public Type getType(QName type) {
        Type res = null;
        for (Type t : this.getTypes()) {
            if (!t.getQName().getNamespaceURI().equals(type.getNamespaceURI()) || !t.getQName().getLocalPart().equals(type.getLocalPart())) continue;
            res = t;
            break;
        }
        return res;
    }

    @Override
    public Type getTypeDouble() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "double"));
    }

    @Override
    public Type getTypeDuration() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "duration"));
    }

    @Override
    public Type getTypeFloat() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "float"));
    }

    @Override
    public Type getTypeInteger() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "integer"));
    }

    @Override
    public Type getTypeLong() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
    }

    @Override
    public Type getTypeShort() {
        return this.getType(new QName("http://www.w3.org/2001/XMLSchema", "short"));
    }

    public void addAttribute(AbsItfAttribute attr) {
        defaultSchema.addAttribute(attr);
    }

    public void addElement(AbsItfElement elmt) {
        defaultSchema.addElement(elmt);
    }

    public void addImport(AbsItfImport importDef) {
        defaultSchema.addImport(importDef);
    }

    public void addInclude(AbsItfInclude includeDef) throws SchemaException {
        defaultSchema.addInclude(includeDef);
    }

    public void addType(AbsItfType absItfType) {
        defaultSchema.addType(absItfType);
    }

    public AbsItfAttribute createAttribute() {
        return defaultSchema.createAttribute();
    }

    public AbsItfType createComplexType() {
        return defaultSchema.createComplexType();
    }

    public AbsItfElement createElement() {
        return defaultSchema.createElement();
    }

    public AbsItfImport createImport() throws SchemaException {
        return defaultSchema.createImport();
    }

    public AbsItfInclude createInclude() throws SchemaException {
        return defaultSchema.createInclude();
    }

    public AbsItfType createSimpleType() {
        return defaultSchema.createSimpleType();
    }

    public List<AbsItfElement> findElementsInAllSchema(QName element) {
        return defaultSchema.findElementsInAllSchema(element);
    }

    @Override
    public NamespaceMapperImpl getAllNamespaces() {
        return defaultSchema.getAllNamespaces();
    }

    public AbsItfAttribute getAttribute(QName attr) {
        return defaultSchema.getAttribute(attr);
    }

    public List<AbsItfAttribute> getAttributes() {
        return defaultSchema.getAttributes();
    }

    @Override
    public List<String> getBlockDefault() {
        return defaultSchema.getBlockDefault();
    }

    @Override
    public URI getDocumentURI() {
        return defaultSchema.getDocumentURI();
    }

    public AbsItfElement getElement(QName element) {
        return defaultSchema.getElement(element);
    }

    public List<AbsItfElement> getElements() {
        return defaultSchema.getElements();
    }

    @Override
    public List<String> getFinalDefault() {
        return defaultSchema.getFinalDefault();
    }

    public List<AbsItfImport> getImports(String namespaceURI) {
        return defaultSchema.getImports(namespaceURI);
    }

    public List<AbsItfImport> getImports() {
        return defaultSchema.getImports();
    }

    public List<AbsItfInclude> getIncludes(URI locationURI) throws URISyntaxException {
        return defaultSchema.getIncludes(locationURI);
    }

    public List<AbsItfInclude> getIncludes() {
        return defaultSchema.getIncludes();
    }

    @Override
    public String getLang() {
        return defaultSchema.getLang();
    }

    @Override
    public String getTargetNamespace() {
        return defaultSchema.getTargetNamespace();
    }

    @Override
    public String getVersion() {
        return defaultSchema.getVersion();
    }

    public AbsItfImport removeImport(AbsItfImport importDef) {
        return defaultSchema.removeImport(importDef);
    }

    public AbsItfInclude removeInclude(AbsItfInclude includeDef) throws SchemaException {
        return defaultSchema.removeInclude(includeDef);
    }

    @Override
    public void setDocumentURI(URI documentBaseURI) {
        defaultSchema.setDocumentURI(documentBaseURI);
    }

    @Override
    public void setTargetNamespace(String tns) {
        defaultSchema.setTargetNamespace(tns);
    }

    @Override
    public Map<QName, String> getOtherAttributes() throws XmlException {
        return defaultSchema.getOtherAttributes();
    }

    @Override
    public void setDocumentation(Documentation doc) {
        defaultSchema.setDocumentation(doc);
    }

    @Override
    public FormChoice getAttributeFormDefault() {
        return defaultSchema.getAttributeFormDefault();
    }

    @Override
    public FormChoice getElementFormDefault() {
        return defaultSchema.getElementFormDefault();
    }

    @Override
    public void setAttributeFormDefault(FormChoice form) {
        defaultSchema.setAttributeFormDefault(form);
    }

    @Override
    public void setElementFormDefault(FormChoice form) {
        defaultSchema.setElementFormDefault(form);
    }

    @Override
    public Documentation createDocumentation() {
        return defaultSchema.createDocumentation();
    }

    @Override
    public Documentation getDocumentation() {
        return defaultSchema.getDocumentation();
    }

    static {
        URL schemaUrl = SchemaJAXBContext.class.getResource("/schema/XMLSchemaWithoutDTD.xsd");
        try {
            defaultSchema = new SchemaReaderImpl().read(schemaUrl);
        }
        catch (XmlException e) {
            e.printStackTrace();
            LOG.warning("Error to read default parent => " + e.getMessage());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            LOG.warning("Error to read default parent => " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warning("I/O error reading " + schemaUrl.toString() + " : " + e.getMessage());
        }
        INSTANCE = new DefaultSchemaImpl();
    }
}

