/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl11;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.util.EasyXMLFilter;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    private static final Logger LOG = Logger.getLogger(WSDLReaderImpl.class.getName());

    public WSDLReaderImpl() throws WSDLException {
        WSDLJAXBContext.getInstance();
    }

    @Override
    public Description read(URL wsdlURL) throws WSDLException, IOException, URISyntaxException {
        try {
            InputSource inputSource = new InputSource(wsdlURL.openStream());
            inputSource.setSystemId(wsdlURL.toString());
            return this.read(inputSource);
        }
        catch (MalformedURLException e) {
            throw new WSDLException("The provided well-formed URL has been detected as malformed !!", e);
        }
    }

    @Override
    public Description read(InputSource inputSource) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(inputSource, null, null, true);
    }

    @Override
    public Description read(Document doc) throws WSDLException, URISyntaxException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(baos);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(doc), streamResult);
            baos.flush();
            baos.close();
            InputSource documentInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            documentInputSource.setSystemId(doc.getBaseURI());
            return this.read(documentInputSource);
        }
        catch (TransformerConfigurationException e) {
            throw new WSDLException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new WSDLException(e);
        }
        catch (TransformerException e) {
            throw new WSDLException(e);
        }
        catch (IOException e) {
            throw new WSDLException(e);
        }
    }

    @Override
    public Description read(InputSource source, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(source, descriptionImports, schemaImports, true);
    }

    @Override
    public Description read(InputSource inputSource, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports, boolean deleteImports) throws WSDLException, MalformedURLException, URISyntaxException {
        URI systemIdURI;
        String systemId = inputSource.getSystemId();
        if (systemId != null) {
            systemIdURI = new URI(systemId);
            this.setDocumentBaseURI(systemIdURI);
        } else {
            systemIdURI = new File(".").toURI();
        }
        DescriptionImpl desc = null;
        if (deleteImports) {
            this.getImportList().clear();
        }
        try {
            LOG.fine("Loading " + systemIdURI);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            EasyXMLFilter filter = new EasyXMLFilter(xmlReader);
            SAXSource saxSource = new SAXSource(filter, inputSource);
            Unmarshaller unmarshaller = WSDLJAXBContext.getInstance().getJaxbContext().createUnmarshaller();
            JAXBElement<TDefinitions> wsdlBinding = unmarshaller.unmarshal(saxSource, TDefinitions.class);
            TDefinitions def = wsdlBinding.getValue();
            desc = new DescriptionImpl(systemIdURI, def, filter.getNamespaceMapper(), filter.getSchemaLocator(), this.getFeatures(), descriptionImports, schemaImports, this);
        }
        catch (JAXBException e) {
            if (e.getLinkedException() != null) {
                throw new WSDLException("Can not get wsdl at: " + systemIdURI.toString(), e.getLinkedException());
            }
            throw new WSDLException("Can not get wsdl at: " + systemIdURI.toString(), e);
        }
        catch (SAXException e) {
            throw new WSDLException("Can not get wsdl at: " + systemIdURI.toString(), e);
        }
        catch (WSDLImportException e) {
            throw new WSDLException("Can not get wsdl at: " + systemIdURI.toString(), e);
        }
        catch (NumberFormatException e) {
            throw new WSDLException("Can not get wsdl at: " + systemIdURI.toString() + " WSDL too large !", e);
        }
        return desc;
    }
}

