/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import spoon.processing.Builder;
import spoon.processing.Environment;
import spoon.reflect.CoreFactory;
import spoon.reflect.factory.AnnotationFactory;
import spoon.reflect.factory.ClassFactory;
import spoon.reflect.factory.CodeFactory;
import spoon.reflect.factory.CompilationUnitFactory;
import spoon.reflect.factory.ConstructorFactory;
import spoon.reflect.factory.EnumFactory;
import spoon.reflect.factory.EvalFactory;
import spoon.reflect.factory.ExecutableFactory;
import spoon.reflect.factory.FieldFactory;
import spoon.reflect.factory.InterfaceFactory;
import spoon.reflect.factory.MethodFactory;
import spoon.reflect.factory.PackageFactory;
import spoon.reflect.factory.TemplateFactory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.DefaultCoreFactory;
import spoon.support.StandardEnvironment;
import spoon.support.builder.SpoonBuildingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient AnnotationFactory Annotation;
    private transient ClassFactory Class;
    private transient CodeFactory Code;
    private transient ConstructorFactory Constructor;
    private transient CoreFactory Core;
    private transient EnumFactory Enum;
    private transient Environment Environment;
    private transient ExecutableFactory Executable;
    private transient EvalFactory Eval;
    private transient FieldFactory Field;
    private transient InterfaceFactory Interface;
    private transient MethodFactory Method;
    private PackageFactory Package;
    private CompilationUnitFactory CompilationUnit;
    private TemplateFactory Template;
    private transient TypeFactory Type;
    static Factory launchingFactory;
    protected transient Builder builder;

    public AnnotationFactory Annotation() {
        if (this.Annotation == null) {
            this.Annotation = new AnnotationFactory(this);
        }
        return this.Annotation;
    }

    public ClassFactory Class() {
        if (this.Class == null) {
            this.Class = new ClassFactory(this);
        }
        return this.Class;
    }

    public CodeFactory Code() {
        if (this.Code == null) {
            this.Code = new CodeFactory(this);
        }
        return this.Code;
    }

    public ConstructorFactory Constructor() {
        if (this.Constructor == null) {
            this.Constructor = new ConstructorFactory(this);
        }
        return this.Constructor;
    }

    public CoreFactory Core() {
        if (this.Core == null) {
            this.Core = new DefaultCoreFactory();
        }
        return this.Core;
    }

    public EnumFactory Enum() {
        if (this.Enum == null) {
            this.Enum = new EnumFactory(this);
        }
        return this.Enum;
    }

    public Environment getEnvironment() {
        if (this.Environment == null) {
            this.Environment = new StandardEnvironment();
        }
        return this.Environment;
    }

    public ExecutableFactory Executable() {
        if (this.Executable == null) {
            this.Executable = new ExecutableFactory(this);
        }
        return this.Executable;
    }

    public EvalFactory Eval() {
        if (this.Eval == null) {
            this.Eval = new EvalFactory(this);
        }
        return this.Eval;
    }

    public FieldFactory Field() {
        if (this.Field == null) {
            this.Field = new FieldFactory(this);
        }
        return this.Field;
    }

    public InterfaceFactory Interface() {
        if (this.Interface == null) {
            this.Interface = new InterfaceFactory(this);
        }
        return this.Interface;
    }

    public MethodFactory Method() {
        if (this.Method == null) {
            this.Method = new MethodFactory(this);
        }
        return this.Method;
    }

    public PackageFactory Package() {
        if (this.Package == null) {
            this.Package = new PackageFactory(this);
        }
        return this.Package;
    }

    public CompilationUnitFactory CompilationUnit() {
        if (this.CompilationUnit == null) {
            this.CompilationUnit = new CompilationUnitFactory(this);
        }
        return this.CompilationUnit;
    }

    public TemplateFactory Template() {
        if (this.Template == null) {
            this.Template = new TemplateFactory(this);
        }
        return this.Template;
    }

    public TypeFactory Type() {
        if (this.Type == null) {
            this.Type = new TypeFactory(this);
        }
        return this.Type;
    }

    private Factory() {
        if (launchingFactory == null) {
            launchingFactory = this;
        }
    }

    public static Factory getLauchingFactory() {
        return launchingFactory;
    }

    public Factory(CoreFactory coreFactory, Environment environment) {
        this();
        this.Environment = environment;
        environment.setFactory(this);
        this.Core = coreFactory;
        this.Core.setMainFactory(this);
    }

    public Builder getBuilder() {
        if (this.builder == null) {
            this.builder = new SpoonBuildingManager(this);
        }
        return this.builder;
    }

    public <T> T convert(Class<T> type, Object o) {
        if (o == null) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return (T)new Boolean(o.toString());
        }
        if (type == Byte.TYPE) {
            return (T)new Byte(o.toString());
        }
        if (type == Character.TYPE) {
            return (T)new Character(o.toString().charAt(0));
        }
        if (type == Double.TYPE) {
            return (T)new Double(o.toString());
        }
        if (type == Float.TYPE) {
            return (T)new Float(o.toString());
        }
        if (type == Integer.TYPE) {
            return (T)new Integer(o.toString());
        }
        if (type == Long.TYPE) {
            return (T)new Long(o.toString());
        }
        if (CtTypeReference.class.isAssignableFrom(type)) {
            return (T)this.Type().createReference(o.toString());
        }
        if (CtExecutableReference.class.isAssignableFrom(type)) {
            return (T)this.Executable().createReference(o.toString());
        }
        if (CtFieldReference.class.isAssignableFrom(type)) {
            return (T)this.Field().createReference(o.toString());
        }
        if (CtPackageReference.class.isAssignableFrom(type)) {
            return (T)this.Package().createReference(o.toString());
        }
        if (type.isEnum()) {
            return java.lang.Enum.valueOf(type, o.toString());
        }
        return (T)o.toString();
    }

    public <T> T convertArray(Class<T> type, Collection<Object> val) {
        if (type.equals(Boolean.TYPE)) {
            boolean[] ret = new boolean[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Boolean.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Byte.TYPE)) {
            byte[] ret = new byte[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Byte.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Character.TYPE)) {
            char[] ret = new char[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Character.TYPE, o).charValue();
            }
            return (T)ret;
        }
        if (type.equals(Double.TYPE)) {
            double[] ret = new double[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Double.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Float.TYPE)) {
            float[] ret = new float[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Float.TYPE, o).floatValue();
            }
            return (T)ret;
        }
        if (type.equals(Integer.TYPE)) {
            int[] ret = new int[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Integer.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(Long.TYPE)) {
            long[] ret = new long[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(Long.TYPE, o);
            }
            return (T)ret;
        }
        if (type.equals(String.class)) {
            String[] ret = new String[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(String.class, o);
            }
            return (T)ret;
        }
        if (CtPackageReference.class.isAssignableFrom(type)) {
            CtPackageReference[] ret = new CtPackageReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtPackageReference.class, o);
            }
            return (T)ret;
        }
        if (CtTypeReference.class.isAssignableFrom(type)) {
            CtTypeReference[] ret = new CtTypeReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtTypeReference.class, o);
            }
            return (T)ret;
        }
        if (CtFieldReference.class.isAssignableFrom(type)) {
            CtFieldReference[] ret = new CtFieldReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtFieldReference.class, o);
            }
            return (T)ret;
        }
        if (CtExecutableReference.class.isAssignableFrom(type)) {
            CtExecutableReference[] ret = new CtExecutableReference[val.size()];
            int i = 0;
            for (Object o : val) {
                ret[i++] = this.convert(CtExecutableReference.class, o);
            }
            return (T)ret;
        }
        if (type.isEnum()) {
            ArrayList<Enum> ret = new ArrayList<Enum>();
            for (Object o : val) {
                ret.add((Enum)this.convert(type, o));
            }
            return (T)ret.toArray((Enum[])Array.newInstance(type, 0));
        }
        return null;
    }
}

