/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import spoon.reflect.Factory;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.factory.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactory
extends TypeFactory {
    private static final long serialVersionUID = 1L;

    public ClassFactory(Factory factory) {
        super(factory);
    }

    public <T> CtClass<T> create(CtClass<?> declaringClass, String simpleName) {
        CtClass c = this.factory.Core().createClass();
        c.setSimpleName(simpleName);
        c.setParent(declaringClass);
        return c;
    }

    public <T> CtClass<T> create(CtPackage owner, String simpleName) {
        CtClass c = this.factory.Core().createClass();
        c.setSimpleName(simpleName);
        if (owner.getTypes().contains(c)) {
            owner.getTypes().remove(c);
        }
        owner.getTypes().add(c);
        c.setParent(owner);
        return c;
    }

    public <T> CtClass<T> create(String qualifiedName) {
        if (this.hasInnerType(qualifiedName) > 0) {
            CtClass<T> declaringClass = this.create(this.getDeclaringTypeName(qualifiedName));
            return this.create(declaringClass, this.getSimpleName(qualifiedName));
        }
        return this.create(this.factory.Package().getOrCreate(this.getPackageName(qualifiedName)), this.getSimpleName(qualifiedName));
    }

    public <T> CtClass<T> get(Class<?> cl) {
        try {
            return (CtClass)super.get(cl);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> CtClass<T> get(String qualifiedName) {
        try {
            return (CtClass)super.get(qualifiedName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

