/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.Factory;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;

    public CodeFactory(Factory factory) {
        super(factory);
    }

    public <T> CtBinaryOperator<T> createBinaryOperator(CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind kind) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setLeftHandOperand(left);
        op.setRightHandOperand(right);
        this.setParent(op, left, right);
        op.setKind(kind);
        return op;
    }

    public <T> CtFieldAccess<Class<T>> createClassAccess(CtTypeReference<T> type) {
        CtFieldAccess ca = this.factory.Core().createFieldAccess();
        CtTypeReference<Class> classType = this.factory.Type().createReference(Class.class);
        ca.setType(classType);
        CtFieldReference<Class> field = this.factory.Core().createFieldReference();
        field.setDeclaringType(type);
        field.setType(classType);
        field.setSimpleName("class");
        ca.setVariable(field);
        return ca;
    }

    public <T> CtInvocation<T> createInvocation(CtExpression<?> target, CtExecutableReference<T> executable, CtExpression<?> ... arguments) {
        ArrayList ext = new ArrayList();
        for (CtExpression<?> arg : arguments) {
            ext.add(arg);
        }
        return this.createInvocation(target, executable, ext);
    }

    public <T> CtInvocation<T> createInvocation(CtExpression<?> target, CtExecutableReference<T> executable, List<CtExpression<?>> arguments) {
        CtInvocation<T> invocation = this.factory.Core().createInvocation();
        invocation.setTarget(target);
        invocation.setExecutable(executable);
        invocation.setArguments(arguments);
        return invocation;
    }

    public <T> CtLiteral<T> createLiteral(T value) {
        CtLiteral<T> l = this.factory.Core().createLiteral();
        l.setValue(value);
        return l;
    }

    public <T> CtNewArray<T[]> createLiteralArray(T[] value) {
        if (!value.getClass().isArray()) {
            throw new RuntimeException("value is not an array");
        }
        if (value.getClass().getComponentType().isArray()) {
            throw new RuntimeException("can only create one-dimension arrays");
        }
        CtNewArray<T[]> array = this.factory.Core().createNewArray();
        array.setType(this.factory.Type().createArrayReference(this.factory.Type().createReference(value.getClass().getComponentType())));
        for (T e : value) {
            CtLiteral<T> l = this.factory.Core().createLiteral();
            l.setValue(e);
            l.setParent(array);
            array.getElements().add(l);
        }
        return array;
    }

    public <T> CtLocalVariable<T> createLocalVariable(CtTypeReference<T> type, String name, CtExpression<T> defaultExpression) {
        CtLocalVariable<T> var = this.factory.Core().createLocalVariable();
        var.setSimpleName(name);
        var.setType(type);
        var.setDefaultExpression(defaultExpression);
        return var;
    }

    public <T> CtLocalVariableReference<T> createLocalVariableReference(CtLocalVariable<T> localVariable) {
        CtLocalVariableReference<T> ref = this.factory.Core().createLocalVariableReference();
        ref.setType(localVariable.getType());
        ref.setSimpleName(localVariable.getSimpleName());
        ref.setDeclaration(localVariable);
        return ref;
    }

    public <T> CtLocalVariableReference<T> createLocalVariableReference(CtTypeReference<T> type, String name) {
        CtLocalVariableReference<T> ref = this.factory.Core().createLocalVariableReference();
        ref.setType(type);
        ref.setSimpleName(name);
        return ref;
    }

    public CtStatementList createStatementList(CtBlock<?> block) {
        CtStatementList l = this.factory.Core().createStatementList();
        for (CtStatement s : block.getStatements()) {
            l.getStatements().add(this.factory.Core().clone(s));
        }
        return l;
    }

    public <T> CtFieldAccess<T> createThisAccess(CtTypeReference<T> type) {
        CtFieldAccess fa = this.factory.Core().createFieldAccess();
        fa.setType(type);
        CtFieldReference<T> field = this.factory.Core().createFieldReference();
        field.setDeclaringType(type);
        field.setType(type);
        field.setSimpleName("this");
        fa.setVariable(field);
        return fa;
    }

    public <T> CtVariableAccess<T> createVariableAccess(CtVariableReference<T> variable, boolean isStatic) {
        CtVariableAccess<T> va;
        if (variable instanceof CtFieldReference) {
            va = this.factory.Core().createFieldAccess();
            if (!isStatic) {
                ((CtFieldAccess)va).setTarget(this.createThisAccess(((CtFieldReference)variable).getDeclaringType()));
            }
        } else {
            va = this.factory.Core().createVariableAccess();
        }
        va.setVariable(variable);
        va.setType(variable.getType());
        return va;
    }

    public List<CtExpression<?>> createVariableAccesses(List<? extends CtVariable<?>> variables) {
        ArrayList result = new ArrayList();
        for (CtVariable<?> v : variables) {
            result.add(this.createVariableAccess(v.getReference(), v.getModifiers().contains((Object)ModifierKind.STATIC)));
        }
        return result;
    }

    public <A, T extends A> CtAssignment<A, T> createVariableAssignment(CtVariableReference<A> variable, boolean isStatic, CtExpression<T> expression) {
        CtAssignment<A, T> va = this.factory.Core().createAssignment();
        va.setAssignment(expression);
        expression.setParent(va);
        CtVariableAccess<A> vaccess = this.createVariableAccess(variable, isStatic);
        va.setAssigned(vaccess);
        vaccess.setParent(va);
        return va;
    }

    public CtStatementList createVariableAssignments(List<? extends CtVariable> variables, List<? extends CtExpression> expressions) {
        CtStatementList result = this.factory.Core().createStatementList();
        for (int i = 0; i < variables.size(); ++i) {
            result.getStatements().add(this.createVariableAssignment(variables.get(i).getReference(), variables.get(i).getModifiers().contains((Object)ModifierKind.STATIC), expressions.get(i)));
        }
        return result;
    }

    public <R extends CtReference, E extends CtNamedElement> List<R> getReferences(List<E> elements) {
        ArrayList<CtReference> refs = new ArrayList<CtReference>();
        for (CtNamedElement e : elements) {
            refs.add(e.getReference());
        }
        return refs;
    }

    public Set<ModifierKind> modifiers(ModifierKind ... modifiers) {
        TreeSet<ModifierKind> ret = new TreeSet<ModifierKind>();
        for (ModifierKind m : modifiers) {
            ret.add(m);
        }
        return ret;
    }

    public <T> CtCodeSnippetExpression<T> createCodeSnippetExpression(String expression) {
        CtCodeSnippetExpression e = this.factory.Core().createCodeSnippetExpression();
        e.setValue(expression);
        return e;
    }

    public CtCodeSnippetStatement createCodeSnippetStatement(String statement) {
        CtCodeSnippetStatement e = this.factory.Core().createCodeSnippetStatement();
        e.setValue(statement);
        return e;
    }
}

