/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.Factory;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.Import;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.cu.ImportImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;
    Map<String, CompilationUnit> compilationUnits = new TreeMap<String, CompilationUnit>();

    public CompilationUnitFactory(Factory factory) {
        super(factory);
    }

    public CompilationUnit create() {
        CompilationUnit cu = this.factory.Core().createCompilationUnit();
        return cu;
    }

    public CompilationUnit create(String filePath) {
        CompilationUnit cu = this.compilationUnits.get(filePath);
        if (cu == null) {
            if ("".equals(filePath)) {
                cu = this.factory.Core().createVirtualCompilationUnit();
                return cu;
            }
            cu = this.factory.Core().createCompilationUnit();
            cu.setFile(new File(filePath));
            this.compilationUnits.put(filePath, cu);
        }
        return cu;
    }

    public Import createImport(CtTypeReference<?> type) {
        return new ImportImpl(type);
    }

    public Import createImport(Class<?> type) {
        return new ImportImpl(this.getFactory().Type().createReference(type));
    }

    public Import createImport(CtFieldReference<?> field) {
        return new ImportImpl(field);
    }

    public Import createImport(CtPackageReference pack) {
        return new ImportImpl(pack);
    }
}

