/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.template.Template;
import spoon.template.TemplateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFactory
extends SubFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, CtClass<?>> templates = new TreeMap();

    public TemplateFactory(Factory factory) {
        super(factory);
    }

    public void add(CtClass<?> template) {
        if (this.templates.containsKey(template.getQualifiedName())) {
            this.templates.remove(template.getQualifiedName());
        }
        this.templates.put(template.getQualifiedName(), template);
        new CtScanner(){

            public void enter(CtElement e) {
                e.setFactory(TemplateFactory.this.factory);
                super.enter(e);
            }

            protected void enterReference(CtReference e) {
                e.setFactory(TemplateFactory.this.factory);
                super.enterReference(e);
            }
        }.scan(template);
    }

    public Map<String, CtClass<?>> getAll() {
        return this.templates;
    }

    public <T> CtClass<T> get(Class<?> templateClass) {
        return this.get(templateClass.getName());
    }

    public <T> CtClass<T> get(String templateName) {
        if (!this.templates.containsKey(templateName)) {
            throw new TemplateException("Unable to load template \"" + templateName + "\". Check your template source path.");
        }
        return this.templates.get(templateName);
    }

    public void parseTypes() {
        for (CtSimpleType<?> t : this.factory.Type().getAll()) {
            if (!(t instanceof CtClass)) continue;
            for (CtSimpleType<?> nested : ((CtType)t).getNestedTypes()) {
                if (!(nested instanceof CtClass)) continue;
                this.scanType((CtClass)nested);
            }
            this.scanType((CtClass)t);
        }
    }

    private void scanType(CtClass<? extends Template> t) {
        if (this.factory.Type().createReference(Template.class).isAssignableFrom(t.getReference())) {
            this.add(t);
        }
    }

    public boolean isTemplate(CtTypeReference<?> candidate) {
        return this.templates.containsKey(candidate.getQualifiedName());
    }
}

