/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.FilteringOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFilter<T extends CtElement>
implements Filter<T> {
    Filter<T>[] filters;
    FilteringOperator operator;

    @Override
    public boolean matches(T element) {
        switch (this.operator) {
            case INTERSECTION: {
                for (Filter<T> f : this.filters) {
                    if (f.matches(element)) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                for (Filter<T> f : this.filters) {
                    if (!f.matches(element)) continue;
                    return true;
                }
                return false;
            }
            case SUBSTRACTION: {
                if (this.filters.length == 0) {
                    return false;
                }
                if (!this.filters[0].matches(element)) {
                    return false;
                }
                for (int i = 1; i < this.filters.length; ++i) {
                    if (!this.filters[i].matches(element)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public CompositeFilter(FilteringOperator operator, Filter<T> ... filters) {
        this.filters = filters;
        this.operator = operator;
    }

    @Override
    public Class<T> getType() {
        return CtElement.class;
    }
}

