/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.SAXException;
import spoon.processing.Environment;
import spoon.processing.FileGenerator;
import spoon.processing.ProblemFixer;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.processing.ProcessorProperties;
import spoon.processing.Severity;
import spoon.reflect.Factory;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtSimpleType;
import spoon.support.processing.XmlProcessorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardEnvironment
implements Serializable,
Environment {
    public static final String PROPERTIES_EXT = ".xml";
    private static final long serialVersionUID = 1L;
    private boolean debug = false;
    private FileGenerator<? extends CtElement> defaultFileGenerator;
    private int errorCount = 0;
    private transient Factory factory;
    ProcessingManager manager;
    private boolean processingStopped = false;
    private boolean verbose = false;
    private int warningCount = 0;
    private File xmlRootFolder;
    Map<String, ProcessorProperties> processorProperties = new TreeMap<String, ProcessorProperties>();
    int complianceLevel = 5;
    boolean useSourceCodeFragments = false;
    boolean useTabulations = false;
    int tabulationSize = 4;

    public StandardEnvironment() {
    }

    public StandardEnvironment(FileGenerator<? extends CtElement> defaultFileGenerator) {
        this.defaultFileGenerator = defaultFileGenerator;
    }

    @Override
    public void debugMessage(String message) {
        if (this.isDebug()) {
            System.out.println(message);
        }
    }

    @Override
    public FileGenerator<? extends CtElement> getDefaultFileGenerator() {
        return this.defaultFileGenerator;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public ProcessingManager getManager() {
        return this.manager;
    }

    @Override
    public ProcessorProperties getProcessorProperties(String processorName) throws FileNotFoundException, IOException, SAXException {
        if (this.processorProperties.containsKey(processorName)) {
            return this.processorProperties.get(processorName);
        }
        InputStream in = this.getPropertyStream(processorName);
        XmlProcessorProperties prop = null;
        try {
            prop = new XmlProcessorProperties(this.getFactory(), processorName, in);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.processorProperties.put(processorName, prop);
        return prop;
    }

    private InputStream getPropertyStream(String processorName) throws FileNotFoundException {
        for (File child : this.getXmlRootFolder().listFiles()) {
            if (!child.getName().equals(processorName + PROPERTIES_EXT)) continue;
            return new FileInputStream(child);
        }
        throw new FileNotFoundException();
    }

    public File getXmlRootFolder() {
        if (this.xmlRootFolder == null) {
            this.xmlRootFolder = new File(".");
        }
        return this.xmlRootFolder;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isProcessingStopped() {
        return this.processingStopped;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    private void prefix(StringBuffer buffer, Severity severity) {
        switch (severity) {
            case ERROR: {
                buffer.append("error: ");
                ++this.errorCount;
                break;
            }
            case WARNING: {
                buffer.append("warning: ");
                ++this.warningCount;
                break;
            }
        }
    }

    private void print(StringBuffer buffer, Severity severity) {
        switch (severity) {
            case ERROR: 
            case WARNING: {
                System.out.println(buffer.toString());
                break;
            }
            default: {
                if (!this.isVerbose()) break;
                System.out.println(buffer.toString());
            }
        }
    }

    @Override
    public void report(Processor<?> processor, Severity severity, CtElement element, String message) {
        StringBuffer buffer = new StringBuffer();
        this.prefix(buffer, severity);
        buffer.append(message);
        CtSimpleType type = element instanceof CtSimpleType ? (CtSimpleType)element : element.getParent(CtSimpleType.class);
        SourcePosition sp = element.getPosition();
        if (sp == null) {
            buffer.append(" (Unknown Source)");
        } else {
            CtExecutable exe;
            buffer.append(" at " + type.getQualifiedName() + ".");
            CtExecutable ctExecutable = exe = element instanceof CtExecutable ? (CtExecutable)element : element.getParent(CtExecutable.class);
            if (exe != null) {
                buffer.append(exe.getSimpleName());
            }
            buffer.append("(" + sp.getFile().getName() + ":" + sp.getLine() + ")");
        }
        this.print(buffer, severity);
    }

    @Override
    public void report(Processor<?> processor, Severity severity, String message) {
        StringBuffer buffer = new StringBuffer();
        this.prefix(buffer, severity);
        buffer.append(message);
        this.print(buffer, severity);
    }

    @Override
    public void reportEnd() {
        if (!this.isVerbose()) {
            return;
        }
        System.out.print("end of processing: ");
        if (this.warningCount > 0) {
            System.out.print(this.warningCount + " warning");
            if (this.warningCount > 1) {
                System.out.print("s");
            }
            if (this.errorCount > 0) {
                System.out.print(", ");
            }
        }
        if (this.errorCount > 0) {
            System.out.print(this.errorCount + " error");
            if (this.errorCount > 1) {
                System.out.print("s");
            }
        }
        if (this.errorCount + this.warningCount > 0) {
            System.out.print("\n");
        } else {
            System.out.println("no errors, no warnings");
        }
    }

    @Override
    public void reportProgressMessage(String message) {
        if (!this.isVerbose()) {
            return;
        }
        System.out.println(message);
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setDefaultFileGenerator(FileGenerator<? extends CtElement> defaultFileGenerator) {
        this.defaultFileGenerator = defaultFileGenerator;
        defaultFileGenerator.setFactory(this.getFactory());
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public void setManager(ProcessingManager manager) {
        this.manager = manager;
    }

    @Override
    public void setProcessingStopped(boolean processingStopped) {
        this.processingStopped = processingStopped;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setXmlRootFolder(File xmlRootFolder) {
        this.xmlRootFolder = xmlRootFolder;
    }

    @Override
    public int getComplianceLevel() {
        return this.complianceLevel;
    }

    @Override
    public void setComplianceLevel(int level) {
        this.complianceLevel = level;
    }

    @Override
    public void setProcessorProperties(String processorName, ProcessorProperties prop) {
        this.processorProperties.put(processorName, prop);
    }

    @Override
    public void report(Processor<?> processor, Severity severity, CtElement element, String message, ProblemFixer<?> ... fix) {
        this.report(processor, severity, element, message);
    }

    @Override
    public boolean isUsingSourceCodeFragments() {
        return this.useSourceCodeFragments;
    }

    @Override
    public void useSourceCodeFragments(boolean b) {
        this.useSourceCodeFragments = b;
    }

    @Override
    public boolean isUsingTabulations() {
        return this.useTabulations;
    }

    @Override
    public void useTabulations(boolean tabulation) {
        this.useTabulations = tabulation;
    }

    @Override
    public int getTabulationSize() {
        return this.tabulationSize;
    }

    @Override
    public void setTabulationSize(int tabulationSize) {
        this.tabulationSize = tabulationSize;
    }

    @Override
    public String getSourcePath() {
        return ".";
    }
}

