/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import spoon.support.builder.CtFile;
import spoon.support.builder.CtFolder;
import spoon.support.builder.CtResource;
import spoon.support.builder.support.CtFileFile;
import spoon.support.builder.support.CtFolderFile;
import spoon.support.builder.support.CtFolderZip;

public class FileFactory {
    public static boolean isArchive(File f) {
        return f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
    }

    public static boolean isFile(File f) {
        return f.isFile() && !FileFactory.isArchive(f);
    }

    public static CtFile createFile(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        return new CtFileFile(f);
    }

    public static CtResource createResource(File f) throws FileNotFoundException {
        if (f.isFile()) {
            return FileFactory.createFile(f);
        }
        return FileFactory.createFolder(f);
    }

    public static CtFolder createFolder(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString() + " does not exist");
        }
        try {
            if (f.isDirectory()) {
                return new CtFolderFile(f);
            }
            if (FileFactory.isArchive(f)) {
                return new CtFolderZip(f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

