/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import spoon.reflect.Factory;
import spoon.support.builder.JDTCompiler;
import spoon.support.builder.SpoonBuildingManager;

public class SnippetBuilder
extends SpoonBuildingManager {
    public SnippetBuilder(Factory factory) {
        super(factory);
    }

    public boolean build() throws Exception {
        if (this.factory == null) {
            throw new Exception("Factory not initialized");
        }
        JDTCompiler.JAVA_COMPLIANCE = this.factory.getEnvironment().getComplianceLevel();
        this.factory.getEnvironment().debugMessage("compiling sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.compiler = new JDTCompiler();
        this.initCompiler();
        boolean srcSuccess = this.compiler.compileSrc(this.factory, this.sources.getAllJavaFiles());
        if (!srcSuccess) {
            for (CategorizedProblem[] cps : this.compiler.probs) {
                for (int i = 0; i < cps.length; ++i) {
                    CategorizedProblem problem = cps[i];
                    if (problem == null) continue;
                    this.getProblems().add(problem.getMessage());
                }
            }
        }
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        this.factory.getEnvironment().debugMessage("compiling templates: " + this.templates.getAllJavaFiles());
        t = System.currentTimeMillis();
        return srcSuccess;
    }
}

