/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtClassImpl<T>
extends CtTypeImpl<T>
implements CtClass<T> {
    private static final long serialVersionUID = 1L;
    List<CtAnonymousExecutable> anonymousExecutable = new ArrayList<CtAnonymousExecutable>();
    Set<CtConstructor<T>> constructors = new TreeSet<CtConstructor<T>>();
    CtTypeReference<?> superClass;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtClass(this);
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        TreeSet ret = new TreeSet();
        ret.addAll(this.getMethods());
        if (this.getSuperclass() != null && this.getSuperclass().getDeclaration() != null) {
            CtType t = (CtType)this.getSuperclass().getDeclaration();
            ret.addAll(t.getMethods());
        }
        return ret;
    }

    @Override
    public List<CtAnonymousExecutable> getAnonymousExecutables() {
        return this.anonymousExecutable;
    }

    @Override
    public CtConstructor<T> getConstructor(CtTypeReference<?> ... parameterTypes) {
        for (CtConstructor<T> c : this.constructors) {
            boolean cont = c.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < c.getParameters().size() && i < parameterTypes.length; ++i) {
                if (c.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return c;
        }
        return null;
    }

    @Override
    public Set<CtConstructor<T>> getConstructors() {
        return this.constructors;
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return this.superClass;
    }

    @Override
    public void setAnonymousExecutables(List<CtAnonymousExecutable> e) {
        this.anonymousExecutable.clear();
        this.anonymousExecutable.addAll(e);
    }

    @Override
    public void setConstructors(Set<CtConstructor<T>> constructors) {
        this.constructors = constructors;
    }

    @Override
    public void setSuperclass(CtTypeReference<?> superClass) {
        this.superClass = superClass;
    }

    @Override
    public Set<CtAnnotation<? extends Annotation>> getAnnotations() {
        CtSimpleType<?> sup;
        Set<CtAnnotation<? extends Annotation>> annot = super.getAnnotations();
        if (this.getSuperclass() != null && (sup = this.getSuperclass().getDeclaration()) != null) {
            for (CtAnnotation<? extends Annotation> a : sup.getAnnotations()) {
                if (a.getAnnotationType().getAnnotation(Inherited.class) == null) continue;
                annot.add(a);
            }
        }
        return annot;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (this.getSuperclass() != null && this.getSuperclass().isSubtypeOf(type)) {
            return true;
        }
        for (CtTypeReference<?> ref : this.getSuperInterfaces()) {
            if (!ref.isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }
}

