/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.util.RtHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtTypeReferenceImpl<T>
extends CtReferenceImpl
implements CtTypeReference<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeReference<?>> actualTypeArguments = new ArrayList();
    CtTypeReference<?> declaringType;
    CtPackageReference pack;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtTypeReference(this);
    }

    @Override
    public CtTypeReference<?> box() {
        if (!this.isPrimitive()) {
            return this;
        }
        if (this.getSimpleName().equals("int")) {
            return this.factory.Type().createReference(Integer.class);
        }
        if (this.getSimpleName().equals("float")) {
            return this.factory.Type().createReference(Float.class);
        }
        if (this.getSimpleName().equals("long")) {
            return this.factory.Type().createReference(Long.class);
        }
        if (this.getSimpleName().equals("char")) {
            return this.factory.Type().createReference(Character.class);
        }
        if (this.getSimpleName().equals("double")) {
            return this.factory.Type().createReference(Double.class);
        }
        if (this.getSimpleName().equals("boolean")) {
            return this.factory.Type().createReference(Boolean.class);
        }
        if (this.getSimpleName().equals("short")) {
            return this.factory.Type().createReference(Short.class);
        }
        if (this.getSimpleName().equals("byte")) {
            return this.factory.Type().createReference(Byte.class);
        }
        if (this.getSimpleName().equals("void")) {
            return this.factory.Type().createReference(Void.class);
        }
        return this;
    }

    @Override
    public Class<T> getActualClass() {
        if (this.isPrimitive()) {
            String simpleN = this.getSimpleName();
            if (simpleN.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (simpleN.equals("byte")) {
                return Byte.TYPE;
            }
            if (simpleN.equals("double")) {
                return Double.TYPE;
            }
            if (simpleN.equals("int")) {
                return Integer.TYPE;
            }
            if (simpleN.equals("short")) {
                return Short.TYPE;
            }
            if (simpleN.equals("char")) {
                return Character.TYPE;
            }
            if (simpleN.equals("long")) {
                return Long.TYPE;
            }
            if (simpleN.equals("float")) {
                return Float.TYPE;
            }
            if (simpleN.equals("void")) {
                return Void.TYPE;
            }
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(this.getQualifiedName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A a = super.getAnnotation(annotationType);
        if (a == null) {
            return this.getActualClass().getAnnotation(annotationType);
        }
        return a;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] a = super.getAnnotations();
        if (a == null) {
            return this.getActualClass().getAnnotations();
        }
        return a;
    }

    @Override
    public CtSimpleType<T> getDeclaration() {
        if (!this.isPrimitive() && this.getQualifiedName().length() > 0) {
            if (this.getFactory().Template().isTemplate(this)) {
                return this.getFactory().Template().get(this.getQualifiedName());
            }
            return this.getFactory().Type().get(this.getQualifiedName());
        }
        return null;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtPackageReference getPackage() {
        return this.pack;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        if (this.getPackage() != null) {
            return this.getPackage().getSimpleName() + "." + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public boolean isAssignableFrom(CtTypeReference<?> type) {
        if (type != null) {
            return type.isSubtypeOf(this);
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.getSimpleName().equals("boolean") || this.getSimpleName().equals("byte") || this.getSimpleName().equals("double") || this.getSimpleName().equals("int") || this.getSimpleName().equals("short") || this.getSimpleName().equals("char") || this.getSimpleName().equals("long") || this.getSimpleName().equals("float") || this.getSimpleName().equals("void");
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (type instanceof CtTypeParameterReference) {
            return false;
        }
        if (this.isPrimitive() || type.isPrimitive()) {
            return this.equals(type);
        }
        CtSimpleType<?> t2 = type.getDeclaration();
        CtElement t1 = this.getDeclaration();
        if (t1 == null && t2 == null) {
            try {
                if (this instanceof CtArrayTypeReference || type instanceof CtArrayTypeReference) {
                    return ((CtArrayTypeReference)((Object)this)).getComponentType().isSubtypeOf(((CtArrayTypeReference)type).getComponentType());
                }
                Class<T> c1 = this.getActualClass();
                Class<T> c2 = type.getActualClass();
                return c2.isAssignableFrom(c1);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.getQualifiedName().equals(type.getQualifiedName())) {
            return true;
        }
        if (t1 != null) {
            if (t1 instanceof CtType) {
                for (CtTypeReference<?> ref : ((CtType)t1).getSuperInterfaces()) {
                    if (!ref.isSubtypeOf(type)) continue;
                    return true;
                }
                if (t1 instanceof CtClass) {
                    if (this.getFactory().Type().createReference(Object.class).equals(type)) {
                        return true;
                    }
                    if (((CtClass)t1).getSuperclass() != null) {
                        if (((CtClass)t1).getSuperclass().equals(type)) {
                            return true;
                        }
                        return ((CtClass)t1).getSuperclass().isSubtypeOf(type);
                    }
                }
            }
            return false;
        }
        try {
            Class<T> c = this.getActualClass();
            Class<T> candidate = type.getActualClass();
            return candidate.isAssignableFrom(c);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setActualTypeArguments(List<CtTypeReference<?>> actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
    }

    @Override
    public void setDeclaringType(CtTypeReference<?> declaringType) {
        this.declaringType = declaringType;
    }

    @Override
    public void setPackage(CtPackageReference pack) {
        this.pack = pack;
    }

    @Override
    public CtTypeReference<?> unbox() {
        if (!this.isPrimitive()) {
            return this;
        }
        if (this.getActualClass() == Integer.class) {
            return this.factory.Type().createReference(Integer.TYPE);
        }
        if (this.getActualClass() == Float.class) {
            return this.factory.Type().createReference(Float.TYPE);
        }
        if (this.getActualClass() == Long.class) {
            return this.factory.Type().createReference(Long.TYPE);
        }
        if (this.getActualClass() == Character.class) {
            return this.factory.Type().createReference(Character.TYPE);
        }
        if (this.getActualClass() == Double.class) {
            return this.factory.Type().createReference(Double.TYPE);
        }
        if (this.getActualClass() == Boolean.class) {
            return this.factory.Type().createReference(Boolean.TYPE);
        }
        if (this.getActualClass() == Short.class) {
            return this.factory.Type().createReference(Short.TYPE);
        }
        if (this.getActualClass() == Byte.class) {
            return this.factory.Type().createReference(Byte.TYPE);
        }
        if (this.getActualClass() == Void.class) {
            return this.factory.Type().createReference(Void.TYPE);
        }
        return this;
    }

    @Override
    public Collection<CtFieldReference<?>> getDeclaredFields() {
        ArrayList l;
        block4: {
            CtElement t;
            block3: {
                l = new ArrayList();
                t = this.getDeclaration();
                if (t != null) break block3;
                for (Field field : this.getActualClass().getDeclaredFields()) {
                    l.add(this.getFactory().Field().createReference(field));
                }
                if (!this.getActualClass().isAnnotation()) break block4;
                for (AccessibleObject accessibleObject : this.getActualClass().getDeclaredMethods()) {
                    CtTypeReference<?> retRef = this.getFactory().Type().createReference(((Method)accessibleObject).getReturnType());
                    CtFieldReference<?> fr = this.getFactory().Field().createReference(this, retRef, ((Method)accessibleObject).getName());
                    l.add(fr);
                }
                break block4;
            }
            for (CtField<?> f : t.getFields()) {
                l.add(f.getReference());
            }
        }
        return l;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        ArrayList l;
        block6: {
            CtElement t;
            block5: {
                l = new ArrayList();
                t = this.getDeclaration();
                if (t != null) break block5;
                for (Method method : this.getActualClass().getDeclaredMethods()) {
                    l.add(this.getFactory().Method().createReference(method));
                }
                for (Executable executable : this.getActualClass().getDeclaredConstructors()) {
                    l.add(this.getFactory().Constructor().createReference((Constructor)executable));
                }
                break block6;
            }
            if (t instanceof CtType) {
                for (CtMethod ctMethod : ((CtType)t).getMethods()) {
                    l.add(ctMethod.getReference());
                }
            }
            if (!(t instanceof CtClass)) break block6;
            for (CtConstructor ctConstructor : ((CtClass)t).getConstructors()) {
                l.add(ctConstructor.getReference());
            }
        }
        return l;
    }

    @Override
    public Collection<CtFieldReference<?>> getAllFields() {
        ArrayList l = new ArrayList();
        CtElement t = this.getDeclaration();
        if (t == null) {
            Class<T> c = this.getActualClass();
            if (c != null) {
                for (Field f : c.getDeclaredFields()) {
                    l.add(this.getFactory().Field().createReference(f));
                }
                Class<T> sc = c.getSuperclass();
                if (sc != null) {
                    l.addAll(this.getFactory().Type().createReference(sc).getAllFields());
                }
            }
        } else {
            CtTypeReference<?> st;
            for (CtField<?> f : t.getFields()) {
                l.add(f.getReference());
            }
            if (t instanceof CtClass && (st = ((CtClass)t).getSuperclass()) != null) {
                l.addAll(st.getAllFields());
            }
        }
        return l;
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        ArrayList l = new ArrayList();
        CtElement t = this.getDeclaration();
        if (t == null) {
            Class<T> c = this.getActualClass();
            for (Method m : c.getDeclaredMethods()) {
                l.add(this.getFactory().Method().createReference(m));
            }
            Class<T> clazz = c.getSuperclass();
            if (clazz != null) {
                l.addAll(this.getFactory().Type().createReference(clazz).getAllExecutables());
            }
        } else {
            if (t instanceof CtType) {
                for (CtMethod ctMethod : ((CtType)t).getMethods()) {
                    l.add(ctMethod.getReference());
                }
            }
            if (t instanceof CtClass) {
                for (CtConstructor ctConstructor : ((CtClass)t).getConstructors()) {
                    l.add(ctConstructor.getReference());
                }
                CtTypeReference<?> st = ((CtClass)t).getSuperclass();
                if (st != null) {
                    l.addAll(st.getAllExecutables());
                }
            }
        }
        return l;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            return t.getModifiers();
        }
        Class<T> c = this.getActualClass();
        if (c != null) {
            return RtHelper.getModifiers(c.getModifiers());
        }
        return new TreeSet<ModifierKind>();
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            if (t instanceof CtClass) {
                return ((CtClass)t).getSuperclass();
            }
        } else {
            Class<T> sc;
            Class<T> c = this.getActualClass();
            if (c != null && (sc = c.getSuperclass()) != null) {
                return this.getFactory().Type().createReference(sc);
            }
        }
        return null;
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        CtElement t = this.getDeclaration();
        if (t != null) {
            if (t instanceof CtType) {
                return ((CtType)t).getSuperInterfaces();
            }
        } else {
            Class<?>[] sis;
            Class<T> c = this.getActualClass();
            if (c != null && (sis = c.getInterfaces()) != null && sis.length > 0) {
                TreeSet set = new TreeSet();
                for (Class<?> si : sis) {
                    set.add(this.getFactory().Type().createReference(si));
                }
                return set;
            }
        }
        return new TreeSet();
    }
}

