/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import spoon.reflect.Factory;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.VariableAccessFilter;
import spoon.support.template.Parameters;
import spoon.support.template.SkipException;
import spoon.support.template.UndefinedParameterException;
import spoon.template.Local;
import spoon.template.Template;
import spoon.template.TemplateParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstitutionVisitor
extends CtScanner {
    Factory f;
    InheritanceSustitutionScanner inheritanceScanner = new InheritanceSustitutionScanner(this);
    CtExecutableReference<?> S;
    CtTypeReference<?> targetRef;
    CtSimpleType<?> targetType;
    Template template;
    CtTypeReference<? extends Template> templateRef;
    CtTypeReference<Template> templateTypeRef;
    CtClass<? extends Template> templateType;
    Collection<String> parameterNames;

    public SubstitutionVisitor(Factory f, CtSimpleType<?> targetType, Template template) {
        this.f = f;
        this.template = template;
        this.targetType = targetType;
        this.S = f.Executable().createReference(f.Type().createReference(TemplateParameter.class), f.Type().createTypeParameterReference("T"), "S", new CtTypeReference[0]);
        this.templateRef = f.Type().createReference(template.getClass());
        this.templateType = f.Template().get(this.templateRef.getQualifiedName());
        this.parameterNames = Parameters.getNames(this.templateType);
        this.targetRef = f.Type().createReference(targetType);
        this.targetRef.accept(this);
        this.templateTypeRef = f.Type().createReference(Template.class);
    }

    @Override
    public void scan(Collection<? extends CtElement> elements) {
        super.scan(new ArrayList<CtElement>(elements));
    }

    @Override
    public void scan(CtElement element) {
        try {
            this.inheritanceScanner.scan(element);
            super.scan(element);
        }
        catch (SkipException e) {
        }
        catch (UndefinedParameterException upe) {
            this.removeEnclosingStatement(element);
        }
    }

    private void removeEnclosingStatement(CtElement e) {
        if (!(e.getParent() instanceof CtBlock)) {
            this.removeEnclosingStatement(e.getParent());
        } else {
            e.replace(null);
        }
    }

    @Override
    public void scan(CtReference reference) {
        if (reference == null) {
            return;
        }
        this.inheritanceScanner.scan(reference);
        if (!(reference instanceof CtTypeReference)) {
            String name = reference.getSimpleName();
            for (String pname : this.parameterNames) {
                if (!name.contains(pname)) continue;
                name = name.replace(pname, Parameters.getValue(this.template, pname, null).toString());
                reference.setSimpleName(name);
            }
            super.scan(reference);
        } else if (!this.parameterNames.contains(reference.getSimpleName()) || ((CtTypeReference)reference).getDeclaringType() == null || !((CtTypeReference)reference).getDeclaringType().equals(this.templateRef)) {
            super.scan(reference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InheritanceSustitutionScanner
    extends CtInheritanceScanner {
        SubstitutionVisitor parent = null;

        public InheritanceSustitutionScanner(SubstitutionVisitor parent) {
            this.parent = parent;
        }

        @Override
        public <R> void scanCtExecutable(CtExecutable<R> e) {
            for (CtParameter<?> parameter : new ArrayList(e.getParameters())) {
                String name = parameter.getSimpleName();
                for (String pname : SubstitutionVisitor.this.parameterNames) {
                    if (!name.equals(pname)) continue;
                    Object value = Parameters.getValue(SubstitutionVisitor.this.template, pname, null);
                    int i = parameter.getParent().getParameters().indexOf(parameter);
                    if (!(value instanceof List)) continue;
                    List l = (List)value;
                    for (Object p : l) {
                        CtParameter p2 = e.getFactory().Core().clone((CtParameter)p);
                        p2.setParent(parameter.getParent());
                        parameter.getParent().getParameters().add(i++, p2);
                    }
                    parameter.getParent().getParameters().remove(parameter);
                }
            }
            super.scanCtExecutable(e);
        }

        @Override
        public void scanCtElement(CtElement e) {
            CtAnnotation<Local> a = e.getAnnotation(e.getFactory().Type().createReference(Local.class));
            if (a != null) {
                e.getAnnotations().remove(a);
            }
            super.scanCtElement(e);
        }

        @Override
        public void scanCtNamedElement(CtNamedElement element) {
            if (element.getDocComment() != null) {
                element.setDocComment(this.substituteInDocComment(element.getDocComment()));
            }
            String name = element.getSimpleName();
            for (String pname : SubstitutionVisitor.this.parameterNames) {
                if (!name.contains(pname)) continue;
                Object value = Parameters.getValue(SubstitutionVisitor.this.template, pname, null);
                if (value instanceof String) {
                    name = name.replace(pname, (String)value);
                    element.setSimpleName(name);
                    continue;
                }
                if (!(value instanceof CtTypeReference) || !(element instanceof CtSimpleType)) continue;
                name = name.replace(pname, ((CtTypeReference)value).getSimpleName());
                element.setSimpleName(name);
            }
            super.scanCtNamedElement(element);
        }

        private String substituteInDocComment(String docComment) {
            String result = docComment;
            for (String pname : SubstitutionVisitor.this.parameterNames) {
                Object value = Parameters.getValue(SubstitutionVisitor.this.template, pname, null);
                if (!(value instanceof String)) continue;
                result = result.replace(pname, (String)value);
            }
            return result;
        }

        @Override
        public <T> void visitCtClass(CtClass<T> ctClass) {
            ctClass.getSuperInterfaces().remove(SubstitutionVisitor.this.f.Type().createReference(Template.class));
            for (CtMethod<?> ctMethod : new TreeSet(ctClass.getMethods())) {
                if (ctMethod.getAnnotation(Local.class) == null) continue;
                ctClass.getMethods().remove(ctMethod);
            }
            for (CtConstructor ctConstructor : new TreeSet<CtConstructor<T>>(ctClass.getConstructors())) {
                if (ctConstructor.getAnnotation(Local.class) == null) continue;
                ctClass.getConstructors().remove(ctConstructor);
            }
            for (CtField ctField : new TreeSet(ctClass.getFields())) {
                if (ctField.getAnnotation(Local.class) != null || Parameters.isParameterSource(ctField.getReference())) {
                    ctClass.getFields().remove(ctField);
                    continue;
                }
                String name = ctField.getSimpleName();
                for (String pname : SubstitutionVisitor.this.parameterNames) {
                    if (!name.equals(pname)) continue;
                    Object value = Parameters.getValue(SubstitutionVisitor.this.template, pname, null);
                    int i = ctClass.getFields().indexOf(ctField);
                    if (!(value instanceof List)) continue;
                    List l = (List)value;
                    for (Object f : l) {
                        CtField f2 = ctClass.getFactory().Core().clone((CtField)f);
                        f2.setParent(ctClass);
                        ctClass.getFields().add(i++, f2);
                    }
                    ctClass.getFields().remove(ctField);
                }
            }
            super.visitCtClass(ctClass);
        }

        @Override
        public void visitCtForEach(CtForEach foreach) {
            CtFieldAccess fa;
            if (foreach.getExpression() instanceof CtFieldAccess && Parameters.isParameterSource((fa = (CtFieldAccess)foreach.getExpression()).getVariable())) {
                Object[] value = (Object[])Parameters.getValue(SubstitutionVisitor.this.template, fa.getVariable().getSimpleName(), null);
                CtStatementList l = foreach.getFactory().Core().createStatementList();
                CtStatement body = foreach.getBody();
                for (Object element : value) {
                    CtStatement b = foreach.getFactory().Core().clone(body);
                    for (CtVariableAccess va : Query.getElements(b, new VariableAccessFilter(foreach.getVariable().getReference()))) {
                        va.replace((CtElement)element);
                    }
                    l.getStatements().add(b);
                }
                foreach.replace(l);
                throw new SkipException(foreach);
            }
            super.visitCtForEach(foreach);
        }

        @Override
        public <T> void visitCtFieldAccess(CtFieldAccess<T> fieldAccess) {
            CtFieldReference<T> ref = fieldAccess.getVariable();
            if ("length".equals(ref.getSimpleName()) && fieldAccess.getTarget() instanceof CtFieldAccess && Parameters.isParameterSource(ref = ((CtFieldAccess)fieldAccess.getTarget()).getVariable())) {
                Object[] value = (Object[])Parameters.getValue(SubstitutionVisitor.this.template, ref.getSimpleName(), null);
                fieldAccess.replace(fieldAccess.getFactory().Code().createLiteral(value.length));
                throw new SkipException(fieldAccess);
            }
            if (Parameters.isParameterSource(ref)) {
                Object value = Parameters.getValue(SubstitutionVisitor.this.template, ref.getSimpleName(), Parameters.getIndex(fieldAccess));
                CtElement toReplace = fieldAccess;
                if (fieldAccess.getParent() instanceof CtArrayAccess) {
                    toReplace = fieldAccess.getParent();
                }
                if (!(value instanceof TemplateParameter)) {
                    if (value instanceof Class) {
                        toReplace.replace(SubstitutionVisitor.this.f.Code().createClassAccess(SubstitutionVisitor.this.f.Type().createReference(((Class)value).getName())));
                    } else if (value instanceof Enum) {
                        CtTypeReference<?> enumType = SubstitutionVisitor.this.f.Type().createReference(value.getClass());
                        toReplace.replace(SubstitutionVisitor.this.f.Code().createVariableAccess(SubstitutionVisitor.this.f.Field().createReference(enumType, enumType, ((Enum)value).name()), true));
                    } else if (value instanceof List) {
                        List l = (List)value;
                        List<CtExpression<?>> vas = SubstitutionVisitor.this.f.Code().createVariableAccesses(l);
                        CtAbstractInvocation inv = (CtAbstractInvocation)fieldAccess.getParent();
                        int i = inv.getArguments().indexOf(fieldAccess);
                        inv.getArguments().remove(i);
                        inv.getExecutable().getParameterTypes().remove(i);
                        for (CtExpression<?> va : vas) {
                            va.setParent(fieldAccess.getParent());
                            inv.getArguments().add(i, va);
                            inv.getExecutable().getParameterTypes().add(i, va.getType());
                            ++i;
                        }
                    } else if (value != null && value.getClass().isArray()) {
                        toReplace.replace(SubstitutionVisitor.this.f.Code().createLiteralArray((Object[])value));
                    } else {
                        toReplace.replace(SubstitutionVisitor.this.f.Code().createLiteral(value));
                    }
                } else {
                    toReplace.replace(((TemplateParameter)value).getSubstitution(SubstitutionVisitor.this.targetType));
                }
                throw new SkipException(fieldAccess);
            }
            super.visitCtFieldAccess(fieldAccess);
        }

        @Override
        public <T> void visitCtInvocation(CtInvocation<T> invocation) {
            if (invocation.getExecutable().isOverriding(SubstitutionVisitor.this.S)) {
                CtFieldAccess fa = null;
                if (invocation.getTarget() instanceof CtFieldAccess) {
                    fa = (CtFieldAccess)invocation.getTarget();
                }
                if (invocation.getTarget() instanceof CtArrayAccess && ((CtArrayAccess)invocation.getTarget()).getTarget() instanceof CtFieldAccess) {
                    fa = (CtFieldAccess)((CtArrayAccess)invocation.getTarget()).getTarget();
                }
                if (fa != null && fa.getTarget() == null) {
                    TemplateParameter tparamValue = (TemplateParameter)Parameters.getValue(SubstitutionVisitor.this.template, fa.getVariable().getSimpleName(), Parameters.getIndex(fa));
                    CtCodeElement r = null;
                    if (tparamValue != null) {
                        r = tparamValue.getSubstitution(SubstitutionVisitor.this.targetType);
                        r.accept(this.parent);
                    }
                    if (invocation.getParent() instanceof CtReturn && r instanceof CtBlock) {
                        invocation.getParent().replace(r);
                    } else {
                        invocation.replace(r);
                    }
                }
                throw new SkipException(invocation);
            }
            super.visitCtInvocation(invocation);
        }

        @Override
        public <T> void scanCtExpression(CtExpression<T> expression) {
            CtLiteral lit;
            Object o;
            CtTypeReference t;
            for (int i = 0; i < expression.getTypeCasts().size(); ++i) {
                t = expression.getTypeCasts().get(i);
                if (!SubstitutionVisitor.this.parameterNames.contains(t.getSimpleName())) continue;
                o = Parameters.getValue(SubstitutionVisitor.this.template, t.getSimpleName(), null);
                if (o instanceof Class) {
                    t = SubstitutionVisitor.this.f.Type().createReference((Class)o);
                    continue;
                }
                if (o instanceof CtTypeReference) {
                    t = (CtTypeReference)o;
                    expression.getTypeCasts().set(i, t);
                    continue;
                }
                throw new RuntimeException("unsupported reference substitution");
            }
            if (expression instanceof CtLiteral && (lit = (CtLiteral)expression).getValue() instanceof CtTypeReference && SubstitutionVisitor.this.parameterNames.contains((t = (CtTypeReference)lit.getValue()).getSimpleName())) {
                o = Parameters.getValue(SubstitutionVisitor.this.template, t.getSimpleName(), null);
                if (o instanceof Class) {
                    t = SubstitutionVisitor.this.f.Type().createReference((Class)o);
                } else if (o instanceof CtTypeReference) {
                    t = (CtTypeReference)o;
                    lit.setValue(t);
                } else {
                    throw new RuntimeException("unsupported reference substitution");
                }
            }
            super.scanCtExpression(expression);
        }

        @Override
        public <T> void scanCtTypedElement(CtTypedElement<T> e) {
            if (e.getType() != null && SubstitutionVisitor.this.parameterNames.contains(e.getType().getSimpleName())) {
                CtTypeReference o = Parameters.getValue(SubstitutionVisitor.this.template, e.getType().getSimpleName(), null);
                if (o instanceof Class) {
                    o = SubstitutionVisitor.this.f.Type().createReference((Class)((Object)o));
                }
                if (o instanceof CtTypeReference) {
                    CtTypeReference<Object> t = e.getType() instanceof CtArrayTypeReference && !(o instanceof CtArrayTypeReference) ? e.getFactory().Type().createArrayReference(o, ((CtArrayTypeReference)e.getType()).getDimensionCount()) : o;
                    e.setType(t);
                } else {
                    throw new RuntimeException("unsupported reference substitution");
                }
            }
            super.scanCtTypedElement(e);
        }

        @Override
        public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
            this.scanCtReference(reference);
            this.visitCtTypeReference(reference.getDeclaringType());
            this.scanCtGenericElementReference(reference);
        }

        @Override
        public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
            if (reference.equals(SubstitutionVisitor.this.templateRef)) {
                reference.setDeclaringType(SubstitutionVisitor.this.targetRef.getDeclaringType());
                reference.setPackage(SubstitutionVisitor.this.targetRef.getPackage());
                reference.setSimpleName(SubstitutionVisitor.this.targetRef.getSimpleName());
            }
            if (SubstitutionVisitor.this.parameterNames.contains(reference.getSimpleName())) {
                CtTypeReference t;
                Object o = Parameters.getValue(SubstitutionVisitor.this.template, reference.getSimpleName(), null);
                if (o instanceof Class) {
                    t = SubstitutionVisitor.this.f.Type().createReference((Class)o);
                } else if (o instanceof CtTypeReference) {
                    t = (CtTypeReference)o;
                    reference.setActualTypeArguments(t.getActualTypeArguments());
                } else {
                    throw new RuntimeException("unsupported reference substitution");
                }
                reference.setPackage(t.getPackage());
                reference.setSimpleName(t.getSimpleName());
                reference.setDeclaringType(t.getDeclaringType());
            } else if (SubstitutionVisitor.this.templateTypeRef.isAssignableFrom(reference)) {
                CtTypeReference<?> sc = SubstitutionVisitor.this.targetRef.getSuperclass();
                if (sc != null) {
                    reference.setDeclaringType(sc.getDeclaringType());
                    reference.setPackage(sc.getPackage());
                    reference.setSimpleName(sc.getSimpleName());
                } else {
                    reference.setDeclaringType(null);
                    reference.setPackage(SubstitutionVisitor.this.f.Package().createReference("java.lang"));
                    reference.setSimpleName("Object");
                }
            }
            super.visitCtTypeReference(reference);
        }

        @Override
        public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
            String name = variableAccess.getVariable().getSimpleName();
            for (String pname : SubstitutionVisitor.this.parameterNames) {
                if (!name.contains(pname)) continue;
                Object value = Parameters.getValue(SubstitutionVisitor.this.template, pname, null);
                if (value instanceof List && name.equals(pname)) {
                    List l = (List)value;
                    List<CtExpression<?>> vas = SubstitutionVisitor.this.f.Code().createVariableAccesses(l);
                    CtAbstractInvocation inv = (CtAbstractInvocation)variableAccess.getParent();
                    int i = inv.getArguments().indexOf(variableAccess);
                    inv.getArguments().remove(i);
                    inv.getExecutable().getParameterTypes().remove(i);
                    for (CtExpression<?> va : vas) {
                        va.setParent(variableAccess.getParent());
                        inv.getArguments().add(i, va);
                        inv.getExecutable().getParameterTypes().add(i, va.getType());
                        ++i;
                    }
                    throw new SkipException(variableAccess);
                }
                if (!(value instanceof String)) continue;
                name = name.replace(pname, (String)value);
                variableAccess.getVariable().setSimpleName(name);
            }
            CtTypeReference reference = variableAccess.getType();
            if (SubstitutionVisitor.this.parameterNames != null && reference != null && SubstitutionVisitor.this.parameterNames.contains(reference.getSimpleName())) {
                CtTypeReference t;
                Object o = Parameters.getValue(SubstitutionVisitor.this.template, reference.getSimpleName(), null);
                if (o instanceof Class) {
                    t = SubstitutionVisitor.this.f.Type().createReference((Class)o);
                } else if (o instanceof CtTypeReference) {
                    t = (CtTypeReference)o;
                    reference.setActualTypeArguments(t.getActualTypeArguments());
                } else {
                    throw new RuntimeException("unsupported reference substitution");
                }
                variableAccess.setType(t);
            }
            super.visitCtVariableAccess(variableAccess);
        }
    }
}

