/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeReferenceScanner
extends CtScanner {
    Set<CtTypeReference<?>> references;

    public TypeReferenceScanner() {
        this.references = new HashSet();
    }

    public TypeReferenceScanner(HashSet<CtTypeReference<?>> references) {
        this.references = references;
    }

    public Set<CtTypeReference<?>> getReferences() {
        return this.references;
    }

    private <T> boolean addReference(CtTypeReference<T> ref) {
        return this.references.add(ref);
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> fieldAccess) {
        this.enter(fieldAccess);
        this.scan(fieldAccess.getVariable());
        this.scan(fieldAccess.getAnnotations());
        this.scanReferences(fieldAccess.getTypeCasts());
        this.scan(fieldAccess.getVariable());
        this.scan((CtElement)fieldAccess.getTarget());
        this.exit(fieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getDeclaringType());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enterReference(reference);
        this.scanReferences(reference.getParameterTypes());
        this.scanReferences(reference.getActualTypeArguments());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        if (!(reference instanceof CtArrayTypeReference)) {
            if (reference.getDeclaringType() == null) {
                this.addReference(reference);
            } else {
                this.addReference(reference.getDeclaringType());
            }
        }
        super.visitCtTypeReference(reference);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.addReference(annotationType.getReference());
        super.visitCtAnnotationType(annotationType);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.addReference(ctEnum.getReference());
        super.visitCtEnum(ctEnum);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.addReference(intrface.getReference());
        for (CtSimpleType<?> t : intrface.getNestedTypes()) {
            this.addReference(t.getReference());
        }
        super.visitCtInterface(intrface);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.addReference(ctClass.getReference());
        for (CtSimpleType<?> t : ctClass.getNestedTypes()) {
            this.addReference(t.getReference());
        }
        super.visitCtClass(ctClass);
    }
}

