package com.ebmwebsourcing.easybpel.model.bpel.tools.generator;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.PartnerLinkTypeImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.RoleImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TPartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TRole;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.Import;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription.WSDLVersionConstants;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader.FeatureConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.EasyNSFilter;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.IfImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.PickImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.CopyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELBooleanExpressionImpl;

public class BpelFromWsdlManager {

	private static final String wsdlImportType = "http://schemas.xmlsoap.org/wsdl/";

	private org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdlArtefacts;

	private Description wsdlBpel;

	private BPELProcess bpelDef;

	private PickImpl mainPick;


	public BpelFromWsdlManager(Description wsdlBpel, String bpelFileName, String wsdlFileName, String wsdlArtefactsName, String mainSequenceName, String mainPickName) {


		//Set the wsdl describing Bpel interface

		this.wsdlBpel = wsdlBpel;

		// Create a new BPEL Process definition from what is defined in the wsdl description (wsdlBpel)
		XMLReader xmlReader= null;
		try {
			xmlReader = XMLReaderFactory.createXMLReader();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		final EasyNSFilter filter = new EasyNSFilter(xmlReader);
		Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();
		features.put(FeatureConstants.VERBOSE, false);
		features.put(FeatureConstants.IMPORT_DOCUMENTS, true);

		try {
			this.bpelDef = new BPELProcessImpl(new URI(bpelFileName), new TProcess(), filter.getNamespaceMapper(), features);
			this.bpelDef.setName(bpelFileName);
			this.bpelDef.setTargetNamespace(wsdlBpel.getTargetNamespace());
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}



		//Create variables corresponding to messages defined in WSDLBPEL

		createMainVariables();


		//Create wsdl Artefacts containing Partnerlink types and imports



		Description artefactsDescClassic;
		try {
			artefactsDescClassic = WSDLFactory.newInstance().newDescription(WSDLVersionConstants.WSDL11);
			this.wsdlArtefacts = WSDL4BPELFactory.newInstance().addBPELElmt2Description(artefactsDescClassic);

		} catch (WSDL4BPELException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (WSDLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		wsdlArtefacts.setTargetNamespace(this.wsdlBpel.getTargetNamespace()+"Artifacts");

		// Add "process.wsdl" import in Artefacts.wsdl and create main partnerlinktype (will be myRole)

		try {
			initWsdlArtefact(wsdlFileName);
		} catch (SchemaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (WSDLImportException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Add "Artefacts.wsdl" import in BPEL

		addImport(URI.create(this.wsdlImportType), URI.create(wsdlArtefactsName), URI.create(this.wsdlArtefacts.getTargetNamespace()));

		//Set the main partnerlink (myRole) thanks to the only PartnerLinkType defined in Artefacts.wsdl

		PartnerLink pl = this.getBpelDef().createPartnerLink();
		try {
			pl.setPartnerLinkType(this.getWsdlArtefacts().getPartnerLinkTypes().get(0).getQName());
		} catch (WSDL4BPELException e) {

			e.printStackTrace();
		}
		pl.setMyRole(this.wsdlBpel.getInterfaces().get(0).getOperations().get(0).getQName().getLocalPart()+"Role");
		pl.setName("mainPartner");





		// Add the Main scope for this bpelDef (Sequence or Pick)

		SequenceImpl seqMain = new SequenceImpl(new TSequence(), this.bpelDef);
		seqMain.setName(mainSequenceName);
		try {
			this.bpelDef.setActivity(seqMain);
		} catch (BPELException e) {
			
			e.printStackTrace();
		}

		this.mainPick = new PickImpl(new TPick(), seqMain);
		mainPick.setName(mainPickName);
		seqMain.addActivity(mainPick);

	}

	private final void createMainVariables(){
		createVariables(this.wsdlBpel);
	}

	public void createVariables(Description desc) {

		Iterator<InterfaceType> itInterface = desc.getInterfaces().iterator();//this.wsdlBpel.getInterfaces().iterator();
		while(itInterface.hasNext()){
			InterfaceType current = itInterface.next();

			Iterator<Operation> itOperation = current.getOperations().iterator();
			while(itOperation.hasNext()){
				Operation op = itOperation.next();


				//Create variable for input
				this.bpelDef.createBPELElementVariable(op.getInput().getMessageName().getLocalPart()+"VarRequest",
						op.getInput().getMessageName(),
						BPELElementVariable.VariableType.MESSAGE);

				//Create variable for output, if exists
				if(op.getOutput() != null){
					
					this.bpelDef.createBPELElementVariable(op.getOutput().getMessageName().getLocalPart()+"VarResponse",
							op.getOutput().getMessageName(),
							BPELElementVariable.VariableType.MESSAGE);
					//this.bpelDef.addVariable(output);
				}
				// Create variable for fault, if exists
				if(op.getFaults() != null){
					Iterator<Fault> itFaults = op.getFaults().iterator();
					while(itFaults.hasNext()){
						Fault f = itFaults.next();
						this.bpelDef.createBPELElementVariable(f.getMessageName().getLocalPart()+"VarFault",
								f.getMessageName(),
								BPELElementVariable.VariableType.MESSAGE);
						//this.bpelDef.addVariable(fault);
					}
				}
			}

		}




	}

	public Import addArtefactImport(URI location, String namespace){
		Import import1 = null;
		try {

			import1 = this.wsdlArtefacts.createImport();
			import1.setLocationURI(location);
			import1.setNamespaceURI(namespace);
			this.wsdlArtefacts.addImport(import1);


		} catch (WSDLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (WSDLImportException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return import1;


	}

	private void initWsdlArtefact(String wsdlFileName) throws SchemaException, WSDLImportException{

		//Add  import
		Import import1 = this.wsdlArtefacts.createImport();
		import1.setLocationURI(URI.create(wsdlFileName));
		import1.setNamespaceURI(this.wsdlBpel.getTargetNamespace());
		this.wsdlArtefacts.addImport(import1);


		// Create PartnerLinkType for Bpel Interface (will be MyRole)
		PartnerLinkType plt = new PartnerLinkTypeImpl(new TPartnerLinkType(), this.wsdlArtefacts);
		QName pltQName = new QName(wsdlBpel.getInterfaces().get(0).getOperations().get(0).getQName().getNamespaceURI(),
				wsdlBpel.getInterfaces().get(0).getOperations().get(0).getQName().getLocalPart()+"PLT");
		plt.setQName(pltQName);
		Role role = new RoleImpl(new TRole(),plt);
		role.setName(this.wsdlBpel.getInterfaces().get(0).getQName().getLocalPart()+"Role");
		role.setInterface(this.wsdlBpel.getInterfaces().get(0));
		plt.addRole(role);

		this.wsdlArtefacts.addPartnerLinkType(plt);
	}

	public void addImport(Description wsdlDesc, String wsdlFileName){
		//TODO check location... newFile.getName.toURI ?
		addImport(URI.create(this.wsdlImportType), URI.create(wsdlFileName), URI.create(wsdlDesc.getTargetNamespace()));
	}

	public ImportImpl addImport(URI importType, URI location, URI namespace){
		ImportImpl imp = new ImportImpl(new TImport(), this.bpelDef);
		imp.setImportType(importType);
		imp.setLocation(location);
		imp.setNamespace(namespace);
		this.bpelDef.addImport(imp);

		return imp;
	}

	public PartnerLinkType addPartnerLinkType(InterfaceType itf, String role) throws WSDL4BPELException{
		PartnerLinkType plt = new PartnerLinkTypeImpl(new TPartnerLinkType(), this.wsdlArtefacts);
		Role r = new RoleImpl(new TRole(), plt);
		r.setInterface(itf);
		r.setName(role);
		plt.addRole(r);
		QName pltQName = new QName(itf.getQName().getNamespaceURI(),itf.getQName().getLocalPart()+"PLT");
		plt.setQName(pltQName);

		this.wsdlArtefacts.addPartnerLinkType(plt);

		return plt;
	}

	/**
	 * Add an import and its PLT in artefacts from a WSDL Description, a corresponding PL in BPEL
	 * and variables corresponding to operations
	 * @throws WSDLImportException 
	 * @throws WSDLException 
	 */
	public void addPartner(Description wsdlDesc, String wsdlFileName) throws WSDLException, WSDLImportException{

		addArtefactImport(URI.create(wsdlFileName), wsdlDesc.getTargetNamespace());

		if(wsdlDesc.getInterfaces().size()>0){
			PartnerLinkType plt = addPartnerLinkType(wsdlDesc.getInterfaces().get(0),
					wsdlDesc.getInterfaces().get(0).getQName().getLocalPart()+"Role");

			PartnerLink pl = this.bpelDef.createPartnerLink();
			pl.setPartnerLinkType(plt.getQName());
			pl.setName(pl.getPartnerLinkType().getLocalPart().substring(0, pl.getPartnerLinkType().getLocalPart().length()-1));
			if(plt.getRoles().size()>0){
				pl.setPartnerRole(plt.getRoles().get(0).getName());
			}

			createVariables(wsdlDesc);
		}
	}


	
	public If addIf(String ifName,
						   BPELElement parent,
						   String expressionContent,
						   URI expressionLanguage) throws XPathExpressionException{
		
		If res = new IfImpl(new TIf(), parent);
		
		BPELBooleanExpression condition = new BPELBooleanExpressionImpl(new TBooleanExpr(), res);
		condition.setContent(expressionContent);
		condition.setExpressionLanguage(expressionLanguage);
		
		try {
			res.addIfActivity(condition, null);
		} catch (BPELException e) {
			throw new XPathExpressionException(e);
		}
		res.setName(ifName);
		
		
		return res;
	}
	
	public void addElseIf(If _if, String expressionContent, URI expressionLanguage, Activity activity) throws XPathExpressionException, BPELException{
		
		
		BPELBooleanExpression condition = new BPELBooleanExpressionImpl(new TBooleanExpr(), _if);
		condition.setContent(expressionContent);
		condition.setExpressionLanguage(expressionLanguage);
		
		_if.addElseIfActivity(condition, activity);
		
	}

	public Sequence addSequenceOnMessage(
			String variable,
			QName itfQName,
			String messageExchange,
			String operation,
			String partnerlink,
			Pick mainPick){

		OnMessage om = new OnMessageImpl(new TOnMessage(), (PickImpl)mainPick);

		om.setInputVariable(variable);
		om.setInterface(itfQName);
		om.setMessageExchange(messageExchange);
		om.setOperation(operation);
		om.setPartnerLink(partnerlink);

		Sequence seq = new SequenceImpl(new TSequence(), om);
		
		try {
			om.setActivity(seq);
		} catch (BPELException e) {
			
			e.printStackTrace();
		}
		mainPick.addOnMessage(om);

		return seq;
	}

	public void addAssign(Activity a, String assignName, String fromXPath, String toXPath) throws Exception{
		Assign assign1 = new AssignImpl(new TAssign(),a);
		Copy c = new CopyImpl(new TCopy(), assign1);
		From from = new FromImpl(new TFrom(), c);

		from.setContent(fromXPath);
		from.setExpressionLanguage(URI.create("http://www.w3.org/TR/xpath20/"));

		To to = new ToImpl(new TTo(), c);
		to.setExpressionLanguage(URI.create("http://www.w3.org/TR/xpath20/"));
		to.setContent(toXPath);
		c.setFrom(from);
		c.setTo(to);

		assign1.addCopy(c);
		assign1.setName(assignName);

		if(a instanceof Sequence){
			((Sequence) a).addActivity(assign1);
		}else{
			throw new Exception("addActivity not yet implemented for "+a.getClass().getName()+" activity");
		}

	}

	public org.ow2.easywsdl.extensions.wsdl4bpel.api.Description getWsdlArtefacts() {
		return wsdlArtefacts;
	}

	public void setWsdlArtefacts(
			org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdlArtefacts) {
		this.wsdlArtefacts = wsdlArtefacts;
	}

	public Description getWsdlBpel() {
		return wsdlBpel;
	}

	public void setWsdlBpel(Description wsdlBpel) {
		this.wsdlBpel = wsdlBpel;
	}

	public BPELProcess getBpelDef() {
		return bpelDef;
	}

	public void setBpelDef(BPELProcess bpelDef) {
		this.bpelDef = bpelDef;
	}

	public PickImpl getMainPick() {
		return mainPick;
	}





}
